/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsp.zul.impl;

import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.zkoss.jsp.zul.impl.Inline;
import org.zkoss.jsp.zul.impl.PageRenderer;
import org.zkoss.jsp.zul.impl.Zk5Inline;
import org.zkoss.lang.Classes;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.Namespaces;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.Scopes;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ZScript;

public class ZkProxy {
    private static Proxy _proxy;
    private static final String ENTRY_COUNT = "org.zkoss.zk.jsp.entryCount";

    public static Proxy getProxy() {
        if (_proxy == null) {
            try {
                Classes.forNameByThread((String)"org.zkoss.zk.ui.sys.PageRenderer");
                _proxy = ZkProxy.newProxy5();
            }
            catch (ClassNotFoundException ex) {
                _proxy = ZkProxy.newProxy3();
            }
        }
        return _proxy;
    }

    private static boolean enter(Proxy proxy, Execution exec) {
        Integer cnt = (Integer)proxy.getAttribute(exec, ENTRY_COUNT);
        proxy.setAttribute(exec, ENTRY_COUNT, cnt != null ? cnt + 1 : 1);
        return cnt == null || cnt == 0;
    }

    private static boolean exit(Proxy proxy, Execution exec) {
        Integer cnt = (Integer)proxy.getAttribute(exec, ENTRY_COUNT);
        proxy.setAttribute(exec, ENTRY_COUNT, cnt != null ? cnt - 1 : 0);
        return cnt == null || cnt <= 1;
    }

    private static Proxy newProxy5() {
        return new Proxy(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void interpret(Page page, Component comp, ZScript zs) {
                Scope scope = Scopes.beforeInterpret((Scope)(comp != null ? comp : page));
                try {
                    page.interpret(zs.getLanguage(), zs.getContent(page, comp), scope);
                }
                finally {
                    Scopes.afterInterpret();
                }
            }

            public void setPageOnly(Execution exec) {
                this.setAttribute(exec, "org.zkoss.zk.ui.page.redrawCtrl", "page");
            }

            public void addMold(ComponentDefinition compdef, String widgetClass, String moldName, String moldURI) {
                if (widgetClass != null) {
                    compdef.setDefaultWidgetClass(widgetClass);
                }
                if (moldURI != null && moldURI.length() != 0) {
                    throw new UnsupportedOperationException("moldURI not supported in 5.0 or later");
                }
            }

            public void beforeRender(Execution exec, Page page) {
                if (ZkProxy.enter(this, exec)) {
                    this.setAttribute(exec, "org.zkoss.zk.ui.page.renderer", new PageRenderer());
                }
            }

            public void afterRender(Execution exec, Page page) {
                if (ZkProxy.exit(this, exec)) {
                    this.removeAttribute(exec, "org.zkoss.zk.ui.page.redrawCtrl");
                    this.removeAttribute(exec, "org.zkoss.zk.ui.page.renderer");
                }
            }

            public Object getAttribute(Execution exec, String name) {
                return exec.getAttribute(name);
            }

            public void setAttribute(Execution exec, String name, Object value) {
                exec.setAttribute(name, value);
            }

            public void removeAttribute(Execution exec, String name) {
                exec.removeAttribute(name);
            }

            public Inline newInline(String txt) {
                return new Zk5Inline(txt);
            }
        };
    }

    private static Proxy newProxy3() {
        return new Proxy(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void interpret(Page page, Component comp, ZScript zs) {
                HashMap backup = new HashMap();
                Namespace ns = comp != null ? Namespaces.beforeInterpret(backup, (Component)comp, (boolean)false) : Namespaces.beforeInterpret(backup, (Page)page, (boolean)false);
                try {
                    page.interpret(zs.getLanguage(), zs.getContent(page, comp), ns);
                }
                finally {
                    Namespaces.afterInterpret(backup, (Namespace)ns, (boolean)false);
                }
            }

            public void setPageOnly(Execution exec) {
                this.setAttribute(exec, "org.zkoss.zk.ui.redrawByInclude", Boolean.TRUE);
            }

            public void addMold(ComponentDefinition compdef, String widgetClass, String moldName, String moldURI) {
                if (moldURI != null && moldURI.length() != 0) {
                    compdef.addMold(moldName == null || moldName.length() == 0 ? "default" : moldName, moldURI.startsWith("class:") ? moldURI : moldURI, null);
                }
                if (widgetClass != null && widgetClass.length() != 0) {
                    throw new UnsupportedOperationException("widgetClass not supported in 5.0.7");
                }
            }

            public void beforeRender(Execution exec, Page page) {
                ZkProxy.enter(this, exec);
            }

            public void afterRender(Execution exec, Page page) {
                if (ZkProxy.exit(this, exec)) {
                    this.removeAttribute(exec, "org.zkoss.zk.ui.redrawByInclude");
                }
            }

            public Object getAttribute(Execution exec, String name) {
                return ((ServletRequest)exec.getNativeRequest()).getAttribute(name);
            }

            public void setAttribute(Execution exec, String name, Object value) {
                ((ServletRequest)exec.getNativeRequest()).setAttribute(name, value);
            }

            public void removeAttribute(Execution exec, String name) {
                ((ServletRequest)exec.getNativeRequest()).removeAttribute(name);
            }

            public Inline newInline(String txt) {
                return new Inline(txt);
            }
        };
    }

    public static interface Proxy {
        public void interpret(Page var1, Component var2, ZScript var3);

        public void setPageOnly(Execution var1);

        public void addMold(ComponentDefinition var1, String var2, String var3, String var4);

        public void beforeRender(Execution var1, Page var2);

        public void afterRender(Execution var1, Page var2);

        public Object getAttribute(Execution var1, String var2);

        public void setAttribute(Execution var1, String var2, Object var3);

        public void removeAttribute(Execution var1, String var2);

        public Inline newInline(String var1);
    }
}

