/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jxpath.JXPathBasicBeanInfo;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.MapDynamicPropertyHandler;
import org.apache.commons.jxpath.util.ClassLoaderUtil;

public class JXPathIntrospector {
    private static Map byClass = Collections.synchronizedMap(new HashMap());
    private static Map byInterface = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAtomicClass(Class beanClass) {
        Map map = byClass;
        synchronized (map) {
            byClass.put(beanClass, new JXPathBasicBeanInfo(beanClass, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDynamicClass(Class beanClass, Class dynamicPropertyHandlerClass) {
        JXPathBasicBeanInfo bi = new JXPathBasicBeanInfo(beanClass, dynamicPropertyHandlerClass);
        if (beanClass.isInterface()) {
            Map map = byInterface;
            synchronized (map) {
                byInterface.put(beanClass, bi);
            }
        }
        Map map = byClass;
        synchronized (map) {
            byClass.put(beanClass, bi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JXPathBeanInfo getBeanInfo(Class beanClass) {
        JXPathBeanInfo beanInfo = (JXPathBeanInfo)byClass.get(beanClass);
        if (beanInfo == null) {
            beanInfo = JXPathIntrospector.findDynamicBeanInfo(beanClass);
            if (beanInfo == null && (beanInfo = JXPathIntrospector.findInformant(beanClass)) == null) {
                beanInfo = new JXPathBasicBeanInfo(beanClass);
            }
            Map map = byClass;
            synchronized (map) {
                byClass.put(beanClass, beanInfo);
            }
        }
        return beanInfo;
    }

    private static JXPathBeanInfo findDynamicBeanInfo(Class beanClass) {
        Class sup;
        JXPathBeanInfo beanInfo;
        if (beanClass.isInterface() && (beanInfo = (JXPathBeanInfo)byInterface.get(beanClass)) != null && beanInfo.isDynamic()) {
            return beanInfo;
        }
        Class<?>[] interfaces = beanClass.getInterfaces();
        if (interfaces != null) {
            for (Class<?> element : interfaces) {
                beanInfo = JXPathIntrospector.findDynamicBeanInfo(element);
                if (beanInfo == null || !beanInfo.isDynamic()) continue;
                return beanInfo;
            }
        }
        if ((sup = beanClass.getSuperclass()) != null) {
            beanInfo = (JXPathBeanInfo)byClass.get(sup);
            if (beanInfo != null && beanInfo.isDynamic()) {
                return beanInfo;
            }
            return JXPathIntrospector.findDynamicBeanInfo(sup);
        }
        return null;
    }

    private static synchronized JXPathBeanInfo findInformant(Class beanClass) {
        String name = beanClass.getName() + "XBeanInfo";
        try {
            return (JXPathBeanInfo)JXPathIntrospector.instantiate(beanClass, name);
        }
        catch (Exception exception) {
            try {
                if (JXPathBeanInfo.class.isAssignableFrom(beanClass)) {
                    return (JXPathBeanInfo)beanClass.newInstance();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
    }

    private static Object instantiate(Class sibling, String className) throws Exception {
        ClassLoader cl = sibling.getClassLoader();
        if (cl != null) {
            try {
                Class<?> cls = cl.loadClass(className);
                return cls.newInstance();
            }
            catch (Exception cls) {
                // empty catch block
            }
        }
        Class cls = ClassLoaderUtil.getClass(className);
        return cls.newInstance();
    }

    static {
        JXPathIntrospector.registerAtomicClass(Class.class);
        JXPathIntrospector.registerAtomicClass(Boolean.TYPE);
        JXPathIntrospector.registerAtomicClass(Boolean.class);
        JXPathIntrospector.registerAtomicClass(Byte.TYPE);
        JXPathIntrospector.registerAtomicClass(Byte.class);
        JXPathIntrospector.registerAtomicClass(Character.TYPE);
        JXPathIntrospector.registerAtomicClass(Character.class);
        JXPathIntrospector.registerAtomicClass(Short.TYPE);
        JXPathIntrospector.registerAtomicClass(Short.class);
        JXPathIntrospector.registerAtomicClass(Integer.TYPE);
        JXPathIntrospector.registerAtomicClass(Integer.class);
        JXPathIntrospector.registerAtomicClass(Long.TYPE);
        JXPathIntrospector.registerAtomicClass(Long.class);
        JXPathIntrospector.registerAtomicClass(Float.TYPE);
        JXPathIntrospector.registerAtomicClass(Float.class);
        JXPathIntrospector.registerAtomicClass(Double.TYPE);
        JXPathIntrospector.registerAtomicClass(Double.class);
        JXPathIntrospector.registerAtomicClass(String.class);
        JXPathIntrospector.registerAtomicClass(java.util.Date.class);
        JXPathIntrospector.registerAtomicClass(Date.class);
        JXPathIntrospector.registerAtomicClass(Time.class);
        JXPathIntrospector.registerAtomicClass(Timestamp.class);
        JXPathIntrospector.registerDynamicClass(Map.class, MapDynamicPropertyHandler.class);
    }
}

