/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;

public class Step {
    private final int axis;
    private final NodeTest nodeTest;
    private final Expression[] predicates;

    protected Step(int axis, NodeTest nodeTest, Expression[] predicates) {
        this.axis = axis;
        this.nodeTest = nodeTest;
        this.predicates = predicates;
    }

    public int getAxis() {
        return this.axis;
    }

    public NodeTest getNodeTest() {
        return this.nodeTest;
    }

    public Expression[] getPredicates() {
        return this.predicates;
    }

    public boolean isContextDependent() {
        if (this.predicates != null) {
            for (Expression predicate : this.predicates) {
                if (!predicate.isContextDependent()) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int axis = this.getAxis();
        if (axis == 2) {
            buffer.append(this.nodeTest);
        } else if (axis == 5) {
            buffer.append('@');
            buffer.append(this.nodeTest);
        } else if (axis == 1 && this.nodeTest instanceof NodeTypeTest && ((NodeTypeTest)this.nodeTest).getNodeType() == 1) {
            buffer.append(".");
        } else if (axis == 3 && this.nodeTest instanceof NodeTypeTest && ((NodeTypeTest)this.nodeTest).getNodeType() == 1) {
            buffer.append("..");
        } else if (axis == 13 && this.nodeTest instanceof NodeTypeTest && ((NodeTypeTest)this.nodeTest).getNodeType() == 1 && (this.predicates == null || this.predicates.length == 0)) {
            buffer.append("");
        } else {
            buffer.append(Step.axisToString(axis));
            buffer.append("::");
            buffer.append(this.nodeTest);
        }
        Expression[] predicates = this.getPredicates();
        if (predicates != null) {
            for (Expression predicate : predicates) {
                buffer.append('[');
                buffer.append(predicate);
                buffer.append(']');
            }
        }
        return buffer.toString();
    }

    public static String axisToString(int axis) {
        switch (axis) {
            case 1: {
                return "self";
            }
            case 2: {
                return "child";
            }
            case 3: {
                return "parent";
            }
            case 4: {
                return "ancestor";
            }
            case 5: {
                return "attribute";
            }
            case 6: {
                return "namespace";
            }
            case 7: {
                return "preceding";
            }
            case 8: {
                return "following";
            }
            case 9: {
                return "descendant";
            }
            case 10: {
                return "ancestor-or-self";
            }
            case 11: {
                return "following-sibling";
            }
            case 12: {
                return "preceding-sibling";
            }
            case 13: {
                return "descendant-or-self";
            }
        }
        return "UNKNOWN";
    }
}

