/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.jxpath.Container;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.util.ClassLoaderUtil;
import org.apache.commons.jxpath.xml.XMLParser;
import org.apache.commons.jxpath.xml.XMLParser2;

public class DocumentContainer
extends XMLParser2
implements Container {
    public static final String MODEL_DOM = "DOM";
    private static final long serialVersionUID = -8713290334113427066L;
    private static HashMap parserClasses = new HashMap();
    private static HashMap parsers;
    private Object document;
    private final URL xmlURL;
    private final String model;

    public static void registerXMLParser(String model, XMLParser parser) {
        parsers.put(model, parser);
    }

    public static void registerXMLParser(String model, String parserClassName) {
        parserClasses.put(model, parserClassName);
    }

    public DocumentContainer(URL xmlURL) {
        this(xmlURL, MODEL_DOM);
    }

    public DocumentContainer(URL xmlURL, String model) {
        this.xmlURL = xmlURL;
        if (xmlURL == null) {
            throw new JXPathException("XML URL is null");
        }
        this.model = model;
    }

    @Override
    public Object getValue() {
        if (this.document == null) {
            try (InputStream stream = null;){
                if (this.xmlURL != null) {
                    stream = this.xmlURL.openStream();
                }
                this.document = this.parseXML(stream);
            }
            catch (IOException ex) {
                throw new JXPathException("Cannot read XML from: " + this.xmlURL.toString(), ex);
            }
        }
        return this.document;
    }

    @Override
    public Object parseXML(InputStream stream) {
        XMLParser parser = DocumentContainer.getParser(this.model);
        if (parser instanceof XMLParser2) {
            XMLParser2 parser2 = (XMLParser2)parser;
            parser2.setValidating(this.isValidating());
            parser2.setNamespaceAware(this.isNamespaceAware());
            parser2.setIgnoringElementContentWhitespace(this.isIgnoringElementContentWhitespace());
            parser2.setExpandEntityReferences(this.isExpandEntityReferences());
            parser2.setIgnoringComments(this.isIgnoringComments());
            parser2.setCoalescing(this.isCoalescing());
        }
        return parser.parseXML(stream);
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private static XMLParser getParser(String model) {
        return (XMLParser)parsers.computeIfAbsent(model, k -> {
            String className = (String)parserClasses.get(model);
            if (className == null) {
                throw new JXPathException("Unsupported XML model: " + model);
            }
            try {
                Class clazz = ClassLoaderUtil.getClass(className, true);
                return (XMLParser)clazz.newInstance();
            }
            catch (Exception ex) {
                throw new JXPathException("Cannot allocate XMLParser: " + className, ex);
            }
        });
    }

    static {
        parserClasses.put(MODEL_DOM, "org.apache.commons.jxpath.xml.DOMParser");
        parsers = new HashMap();
    }
}

