/*
 * Copyright 2007 Gerd Ziegler (www.gerdziegler.de)
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 * @author www.gerdziegler.de
 */
package org.zclasspath;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;

import javax.servlet.ServletContext;

public class ZClassPathItemWebapp implements ZIClassPathItem
{
  private ServletContext ctx;

  private String name;


  public ZClassPathItemWebapp(ServletContext ctx, String name)
  {
    this.ctx = ctx;
    this.name = name;
  }


  public String toString()
  {
    return name;
  }


  /**
   * getInputStream
   *
   * @return InputStream
   */
  public InputStream getInputStream()
  {
    return ctx.getResourceAsStream(name);
  }


  /**
   * getName
   *
   * @return String
   */
  public String getName()
  {
    return name;
  }


  /**
   * getRelativePath
   *
   * @param root
   *          ClassPathItem
   * @return String
   */
  public String getRelativePath(ZIClassPathItem root) throws Exception
  {
    return name.substring(root.getName().length());
  }


  /**
   * isDirectory
   *
   * @return boolean
   */
  public boolean isDirectory()
  {
    return name.endsWith("/");
  }


  /**
   * isFile
   *
   * @return boolean
   */
  public boolean isFile()
  {
    return !name.endsWith("/");
  }


  /**
   * list
   *
   * @return ClassPathItem[]
   */
  public ZIClassPathItem[] list()
  {
    Set<String> set = ctx.getResourcePaths(name);
    if(set==null)
    {
      return new ZIClassPathItem[0];
    }
    ZIClassPathItem[] ret = new ZIClassPathItem[set.size()];
    Iterator iter = set.iterator();
    for (int i = 0; iter.hasNext(); i++)
    {
      String crt = (String) iter.next();
      ret[i] = new ZClassPathItemWebapp(ctx, crt);
    }
    return ret;
  }


  public long getHash() throws Exception
  {
    return System.currentTimeMillis();
  }
}
