package org.zclasspath;

import java.util.ArrayList;
import java.util.List;

public class ZClassPathLocation implements ZIClassPathLocation {
    private final ZIClassPathItem classPathItem;
    private final List<String> parentNames = new ArrayList<String>();

    public ZClassPathLocation(ZIClassPathItem classPathItem) {
        super();
        this.classPathItem = classPathItem;
    }

    public ZClassPathLocation(ZIClassPathItem classPathItem, List<String> parentNames) {
        this.classPathItem = classPathItem;
        this.parentNames.addAll(parentNames);
    }

    public ZClassPathLocation(ZIClassPathLocation location, String parent) {
        this(location.getClassPathItem(), location.getParentNames());        
        parentNames.add(parent);
    }

    public ZIClassPathItem getClassPathItem() {
        return classPathItem;
    }

    public List<String> getParentNames() {
        return parentNames;
    }
}
