/*
 * Copyright 2007 Gerd Ziegler (www.gerdziegler.de) Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License. 20.11.2007 @author
 * www.gerdziegler.de
 */
package org.zclasspath;

import java.lang.annotation.Annotation;
import java.util.List;

public interface ZIClassRepository
{
  public List<Class> getClasses();


  public List<Class> getClassesAnnotatedWithAndAssignableFrom(Class<? extends Annotation> annotationClass, Class clazz);


  public List<Class> getClassesAnnotatedWithAndAssignableTo(Class<? extends Annotation> annotationClass, Class clazz);


  public List<Class> getClassesAssignableFrom(Class clazz);


  public List<Class> getClassesAssignableTo(Class clazz);


  public List<Class> getClassesAnnotatedWith(Class<? extends Annotation> annotationClass);


  public Class getDeclaringClass(Class pojoClass, Class<? extends Annotation> findAnnot);
}
