/*
 * Decompiled with CFR 0.152.
 */
package org.zuchini.reporter;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.zuchini.junit.description.FeatureInfo;
import org.zuchini.junit.description.RowInfo;
import org.zuchini.junit.description.ScenarioInfo;
import org.zuchini.junit.description.StepInfo;
import org.zuchini.reporter.ScenarioResult;

public class JsonReporter
extends RunListener {
    private final Map<String, Integer> generatedIds = new HashMap<String, Integer>();
    private final List<ScenarioResult> results = new ArrayList<ScenarioResult>();
    private final Set<Description> failed = Collections.newSetFromMap(new IdentityHashMap());
    private final Object lock = new Object();

    private static <K, V> void update(Map<K, List<V>> map, K key, V val) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.add(val);
    }

    private static <T extends Annotation> Map<T, List<ScenarioResult>> index(Iterable<ScenarioResult> results, Class<T> clazz) {
        HashMap index = new HashMap();
        for (ScenarioResult result : results) {
            Description description = result.getDescription();
            Annotation scenario = description.getAnnotation(clazz);
            if (scenario == null) {
                throw new IllegalStateException("Description [" + description.getDisplayName() + "] has no annotation of type [" + clazz.getName() + "]");
            }
            JsonReporter.update(index, scenario, result);
        }
        return index;
    }

    private static Map<FeatureInfo, List<ScenarioResult>> byFeature(Iterable<ScenarioResult> results) {
        return JsonReporter.index(results, FeatureInfo.class);
    }

    private static Map<ScenarioInfo, List<ScenarioResult>> byScenario(Iterable<ScenarioResult> results) {
        return JsonReporter.index(results, ScenarioInfo.class);
    }

    public void testStarted(Description description) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFinished(Description description) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.failed.contains(description)) {
                this.results.add(ScenarioResult.success(description));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailure(Failure failure) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.failed.add(failure.getDescription());
            this.results.add(ScenarioResult.failure(failure));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssumptionFailure(Failure failure) {
        Object object = this.lock;
        synchronized (object) {
            this.failed.add(failure.getDescription());
            this.results.add(ScenarioResult.assumptionFailed(failure));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIgnored(Description description) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.failed.add(description);
            this.results.add(ScenarioResult.ignored(description));
        }
    }

    public void testRunStarted(Description description) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ScenarioResult> copyResults() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<ScenarioResult>(this.results);
        }
    }

    public void testRunFinished(Result result) throws Exception {
        Map<FeatureInfo, List<ScenarioResult>> features = JsonReporter.byFeature(this.copyResults());
        String outputPath = System.getProperty("zuchini.reporter.output");
        if (outputPath == null) {
            outputPath = "./zuchini-report.json";
        }
        File outputFile = new File(outputPath).getAbsoluteFile();
        outputFile.getParentFile().mkdirs();
        JsonFactory jsonFactory = new JsonFactory();
        try (JsonGenerator json = jsonFactory.createGenerator(outputFile, JsonEncoding.UTF8);){
            json.useDefaultPrettyPrinter();
            json.writeStartObject();
            json.writeStringField("creation-host", InetAddress.getLocalHost().getHostName());
            json.writeStringField("creation-time", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(new Date()));
            this.writeEnvironment(json);
            json.writeArrayFieldStart("features");
            for (Map.Entry<FeatureInfo, List<ScenarioResult>> featureEntry : features.entrySet()) {
                FeatureInfo feature = featureEntry.getKey();
                Collection value = featureEntry.getValue();
                String name = feature.name();
                json.writeStartObject();
                json.writeStringField("id", this.generateId(name));
                json.writeStringField("uri", feature.uri());
                json.writeNumberField("line", feature.lineNumber());
                this.writeStringArray(json, "tags", feature.tags());
                this.writeStringArray(json, "comments", feature.tags());
                json.writeStringField("keyword", feature.keyword());
                json.writeStringField("title", name);
                json.writeStringField("name", feature.name());
                this.writeScenarios(json, value, this.generatedIds);
                json.writeEndObject();
            }
            json.writeEndArray();
            json.writeEndObject();
        }
    }

    private String generateId(String title) {
        String id = title.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]+", "-").replaceAll("(^-|-$)", "");
        Integer count = this.generatedIds.get(id);
        if (count == null) {
            count = 1;
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.generatedIds.put(id, count);
        return count == 1 ? id : id + "-" + count;
    }

    private void writeStringArray(JsonGenerator json, String name, String[] strings) throws IOException {
        if (strings != null && strings.length > 0) {
            json.writeArrayFieldStart(name);
            for (String tag : strings) {
                json.writeString(tag);
            }
            json.writeEndArray();
        }
    }

    private void writeEnvironment(JsonGenerator json) throws IOException {
        HashMap env;
        Properties properties = new Properties();
        if (!properties.isEmpty()) {
            json.writeObjectFieldStart("properties");
            for (String key : properties.stringPropertyNames()) {
                String val = properties.getProperty(key);
                json.writeStringField(key, val);
            }
            json.writeEndObject();
        }
        if (!(env = new HashMap()).isEmpty()) {
            json.writeObjectFieldStart("environment");
            for (Map.Entry entry : env.entrySet()) {
                json.writeStringField((String)entry.getKey(), (String)entry.getValue());
            }
            json.writeEndObject();
        }
    }

    private void writeScenarios(JsonGenerator json, Collection<ScenarioResult> value, Map<String, Integer> generatedIds) throws IOException {
        Map<ScenarioInfo, List<ScenarioResult>> scenarios = JsonReporter.byScenario(this.results);
        json.writeArrayFieldStart("scenarios");
        for (Map.Entry<ScenarioInfo, List<ScenarioResult>> scenarioEntry : scenarios.entrySet()) {
            ScenarioInfo scenario = scenarioEntry.getKey();
            String description = scenario.name();
            json.writeStartObject();
            json.writeNumberField("line", scenario.lineNumber());
            this.writeStringArray(json, "tags", scenario.tags());
            this.writeStringArray(json, "comments", scenario.comments());
            json.writeStringField("id", this.generateId(description));
            json.writeStringField("keyword", scenario.keyword());
            json.writeStringField("title", description);
            this.writeSteps(json, scenario);
            this.writeResults(json, (Collection<ScenarioResult>)scenarioEntry.getValue());
            json.writeEndObject();
        }
        json.writeEndArray();
    }

    private void writeSteps(JsonGenerator json, ScenarioInfo scenario) throws IOException {
        json.writeArrayFieldStart("steps");
        for (StepInfo step : scenario.steps()) {
            json.writeStartObject();
            this.writeStep(json, step);
            json.writeEndObject();
        }
        json.writeEndArray();
    }

    private void writeStep(JsonGenerator json, StepInfo step) throws IOException {
        json.writeNumberField("line", step.lineNumber());
        json.writeStringField("keyword", step.keyword());
        json.writeStringField("title", step.name());
        this.writeStringArray(json, "tags", step.tags());
        this.writeStringArray(json, "comments", step.comments());
        this.writeStringArray(json, "documents", step.docs());
        this.writeDatatable(json, step);
    }

    private void writeDatatable(JsonGenerator json, StepInfo step) throws IOException {
        if (step.rows() != null && step.rows().length > 0) {
            json.writeObjectFieldStart("datatable");
            json.writeArrayFieldStart("rows");
            for (RowInfo row : step.rows()) {
                json.writeStartObject();
                json.writeNumberField("line", row.lineNumber());
                this.writeStringArray(json, "comments", row.comments());
                this.writeStringArray(json, "tags", row.tags());
                this.writeStringArray(json, "cells", row.cells());
                json.writeEndObject();
            }
            json.writeEndArray();
            json.writeEndObject();
        }
    }

    private static String getStackTrace(Throwable exception) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        return sw.toString();
    }

    private void writeResults(JsonGenerator json, Collection<ScenarioResult> value) throws IOException {
        json.writeArrayFieldStart("results");
        for (ScenarioResult result : value) {
            json.writeStartObject();
            StepInfo step = (StepInfo)result.getDescription().getAnnotation(StepInfo.class);
            if (step != null) {
                json.writeObjectFieldStart("step");
                this.writeStep(json, step);
                json.writeEndObject();
            }
            json.writeBooleanField("success", result.isSuccess());
            json.writeBooleanField("ignored", result.isIgnored());
            json.writeBooleanField("assumptionFailed", result.isAssumptionFailed());
            Throwable exception = result.getException();
            if (exception != null) {
                json.writeStringField("error", exception.getMessage());
                json.writeStringField("stacktrace", JsonReporter.getStackTrace(exception));
            }
            this.writeParameters(json, result);
            this.writeMetadata(json, result);
            json.writeEndObject();
        }
        json.writeEndArray();
    }

    private void writeParameters(JsonGenerator json, ScenarioResult results) throws IOException {
        HashMap parameters = new HashMap();
        if (!parameters.isEmpty()) {
            json.writeObjectFieldStart("parameters");
            for (Map.Entry parameter : parameters.entrySet()) {
                String name = Introspector.decapitalize(((Class)parameter.getKey()).getSimpleName());
                Object value = parameter.getValue();
                this.writeProperty(json, name, value);
            }
            json.writeEndObject();
        }
    }

    private void writeMetadata(JsonGenerator json, ScenarioResult results) throws IOException {
        HashMap metadata = new HashMap();
        if (!metadata.isEmpty()) {
            json.writeObjectFieldStart("metadata");
            for (Map.Entry property : metadata.entrySet()) {
                this.writeProperty(json, (String)property.getKey(), property.getValue());
            }
            json.writeEndObject();
        }
    }

    private void writeProperty(JsonGenerator json, String name, Object value) throws IOException {
        json.writeFieldName(name);
        if (value == null) {
            json.writeNull();
        } else if (value instanceof Number) {
            json.writeNumber(((Number)value).doubleValue());
        } else {
            json.writeString(String.valueOf(value));
        }
    }
}

