/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout;

import java.util.ArrayList;
import java.util.List;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphObject;
import org.ivis.layout.LNode;
import org.ivis.util.IGeometry;
import org.ivis.util.IMath;
import org.ivis.util.PointD;

public class LEdge
extends LGraphObject {
    protected LNode source;
    protected LNode target;
    protected boolean isInterGraph;
    protected double length;
    protected double lengthX;
    protected double lengthY;
    protected boolean isOverlapingSourceAndTarget = false;
    protected List<PointD> bendpoints = new ArrayList<PointD>();
    protected LGraph lca;
    protected LNode sourceInLca;
    protected LNode targetInLca;

    protected LEdge(LNode source, LNode target, Object vEdge) {
        super(vEdge);
        this.source = source;
        this.target = target;
    }

    public LNode getSource() {
        return this.source;
    }

    public void setSource(LNode source) {
        this.source = source;
    }

    public LNode getTarget() {
        return this.target;
    }

    public void setTarget(LNode target) {
        this.target = target;
    }

    public boolean isInterGraph() {
        return this.isInterGraph;
    }

    public double getLength() {
        return this.length;
    }

    public double getLengthX() {
        return this.lengthX;
    }

    public double getLengthY() {
        return this.lengthY;
    }

    public boolean isOverlapingSourceAndTarget() {
        return this.isOverlapingSourceAndTarget;
    }

    public void resetOverlapingSourceAndTarget() {
        this.isOverlapingSourceAndTarget = false;
    }

    public List<PointD> getBendpoints() {
        return this.bendpoints;
    }

    public void reRoute(List<PointD> bendPoints) {
        this.bendpoints.clear();
        this.bendpoints.addAll(bendPoints);
    }

    public LGraph getLca() {
        return this.lca;
    }

    public LNode getSourceInLca() {
        return this.sourceInLca;
    }

    public LNode getTargetInLca() {
        return this.targetInLca;
    }

    public LNode getOtherEnd(LNode node) {
        if (this.source.equals(node)) {
            return this.target;
        }
        if (this.target.equals(node)) {
            return this.source;
        }
        throw new IllegalArgumentException("Node is not incident with this edge");
    }

    public LNode getOtherEndInGraph(LNode node, LGraph graph) {
        LNode otherEnd = this.getOtherEnd(node);
        LGraph root = graph.getGraphManager().getRoot();
        while (true) {
            if (otherEnd.getOwner() == graph) {
                return otherEnd;
            }
            if (otherEnd.getOwner() == root) break;
            otherEnd = otherEnd.getOwner().getParent();
        }
        return null;
    }

    public void updateLength() {
        double[] clipPointCoordinates = new double[4];
        this.isOverlapingSourceAndTarget = IGeometry.getIntersection(this.target.getRect(), this.source.getRect(), clipPointCoordinates);
        if (!this.isOverlapingSourceAndTarget) {
            this.lengthX = clipPointCoordinates[0] - clipPointCoordinates[2];
            this.lengthY = clipPointCoordinates[1] - clipPointCoordinates[3];
            if (Math.abs(this.lengthX) < 1.0) {
                this.lengthX = IMath.sign(this.lengthX);
            }
            if (Math.abs(this.lengthY) < 1.0) {
                this.lengthY = IMath.sign(this.lengthY);
            }
            this.length = Math.sqrt(this.lengthX * this.lengthX + this.lengthY * this.lengthY);
        }
    }

    public void updateLengthSimple() {
        this.lengthX = this.target.getCenterX() - this.source.getCenterX();
        this.lengthY = this.target.getCenterY() - this.source.getCenterY();
        if (Math.abs(this.lengthX) < 1.0) {
            this.lengthX = IMath.sign(this.lengthX);
        }
        if (Math.abs(this.lengthY) < 1.0) {
            this.lengthY = IMath.sign(this.lengthY);
        }
        this.length = Math.sqrt(this.lengthX * this.lengthX + this.lengthY * this.lengthY);
    }

    void printTopology() {
        System.out.print((this.label == null ? "?" : this.label) + "[" + (this.source.label == null ? "?" : this.source.label) + "-" + (this.target.label == null ? "?" : this.target.label) + "] ");
    }
}

