/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.cose;

import java.util.ArrayList;
import java.util.HashMap;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.Layout;
import org.ivis.layout.cose.CoSEGraph;
import org.ivis.layout.cose.CoSENode;
import org.ivis.layout.cose.CoarseningEdge;
import org.ivis.layout.cose.CoarseningGraph;
import org.ivis.layout.cose.CoarseningNode;

public class CoSEGraphManager
extends LGraphManager {
    public CoSEGraphManager(Layout layout) {
        super(layout);
    }

    public ArrayList<CoSEGraphManager> coarsenGraph() {
        int prevNodeCount;
        ArrayList<CoSEGraphManager> MList = new ArrayList<CoSEGraphManager>();
        MList.add(this);
        CoarseningGraph G = new CoarseningGraph(this.getLayout());
        this.convertToCoarseningGraph((CoSEGraph)this.getRoot(), G);
        int currNodeCount = G.getNodes().size();
        do {
            prevNodeCount = currNodeCount;
            G.coarsen();
            CoSEGraphManager lastM = (CoSEGraphManager)MList.get(MList.size() - 1);
            CoSEGraphManager newM = this.coarsen(lastM);
            MList.add(newM);
        } while (prevNodeCount != (currNodeCount = G.getNodes().size()) && currNodeCount > 1);
        this.getLayout().setGraphManager(this);
        MList.remove(MList.size() - 1);
        return MList;
    }

    private void convertToCoarseningGraph(CoSEGraph coseG, CoarseningGraph G) {
        HashMap<CoSENode, CoarseningNode> map = new HashMap<CoSENode, CoarseningNode>();
        for (Object obj : coseG.getNodes()) {
            CoSENode v = (CoSENode)obj;
            if (v.getChild() != null) {
                this.convertToCoarseningGraph((CoSEGraph)v.getChild(), G);
                continue;
            }
            CoarseningNode u = new CoarseningNode();
            u.setReference(v);
            map.put(v, u);
            G.add(u);
        }
        for (Object obj : coseG.getEdges()) {
            LEdge e = (LEdge)obj;
            if (e.getSource().getChild() != null || e.getTarget().getChild() != null) continue;
            G.add(new CoarseningEdge(), (LNode)map.get(e.getSource()), (LNode)map.get(e.getTarget()));
        }
    }

    private CoSEGraphManager coarsen(CoSEGraphManager lastM) {
        CoSEGraphManager newM = new CoSEGraphManager(lastM.getLayout());
        newM.getLayout().setGraphManager(newM);
        newM.addRoot();
        newM.getRoot().vGraphObject = lastM.getRoot().vGraphObject;
        this.coarsenNodes((CoSEGraph)lastM.getRoot(), (CoSEGraph)newM.getRoot());
        lastM.getLayout().setGraphManager(lastM);
        this.addEdges(lastM, newM);
        return newM;
    }

    private void coarsenNodes(CoSEGraph g, CoSEGraph coarserG) {
        for (Object obj : g.getNodes()) {
            CoSENode v = (CoSENode)obj;
            if (v.getChild() != null) {
                v.setNext((CoSENode)coarserG.getGraphManager().getLayout().newNode(null));
                coarserG.getGraphManager().add(coarserG.getGraphManager().getLayout().newGraph(null), v.getNext());
                v.getNext().setPred1(v);
                coarserG.add(v.getNext());
                this.coarsenNodes((CoSEGraph)v.getChild(), (CoSEGraph)v.getNext().getChild());
            } else if (!v.getNext().isProcessed()) {
                coarserG.add(v.getNext());
                v.getNext().setProcessed(true);
            }
            v.getNext().setLocation(v.getLocation().x, v.getLocation().y);
            v.getNext().setHeight(v.getHeight());
            v.getNext().setWidth(v.getWidth());
        }
    }

    private void addEdges(CoSEGraphManager lastM, CoSEGraphManager newM) {
        for (Object obj : lastM.getAllEdges()) {
            LEdge e = (LEdge)obj;
            if (e.isInterGraph() || e.getSource().getChild() != null || e.getTarget().getChild() != null) {
                if (((CoSENode)e.getSource()).getNext().getNeighborsList().contains(((CoSENode)e.getTarget()).getNext())) continue;
                newM.add(newM.getLayout().newEdge(null), ((CoSENode)e.getSource()).getNext(), ((CoSENode)e.getTarget()).getNext());
                continue;
            }
            if (((CoSENode)e.getSource()).getNext() == ((CoSENode)e.getTarget()).getNext() || ((CoSENode)e.getSource()).getNext().getNeighborsList().contains(((CoSENode)e.getTarget()).getNext())) continue;
            newM.add(newM.getLayout().newEdge(null), ((CoSENode)e.getSource()).getNext(), ((CoSENode)e.getTarget()).getNext());
        }
    }
}

