/*
 * Decompiled with CFR 0.152.
 */
package pet.orca.saph;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Saph {
    public static final int DEFAULT_MEMORY_SIZE = 16384;
    public static final int DEFAULT_ITERATIONS = 8;
    private static final int CHUNK_LEN = 64;
    private static final int HASH_LEN = 32;
    private final int memorySize;
    private final int iterations;
    private final MessageDigest currentMd;
    private final MessageDigest partsMd;
    private final byte[] hashBuffer = new byte[32];
    private boolean calculated;

    public Saph() {
        this(16384, 8);
    }

    public Saph(int memorySize, int iterations) {
        if (memorySize < 1) {
            throw new IllegalArgumentException("Memory size must be at least one block");
        }
        if (iterations < 1) {
            throw new IllegalArgumentException("Iterations must be at least one");
        }
        this.memorySize = memorySize;
        this.iterations = iterations;
        try {
            this.partsMd = MessageDigest.getInstance("SHA-256");
            this.currentMd = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Mandatory SHA-256 not available (non-compliant JVM?)", ex);
        }
    }

    public Saph add(String part) {
        if (part == null) {
            throw new IllegalArgumentException("Part may not be null");
        }
        byte[] encoded = part.getBytes(StandardCharsets.UTF_8);
        return this.realAdd(encoded, 0, encoded.length);
    }

    public Saph add(byte[] part) {
        if (part == null) {
            throw new IllegalArgumentException("Part may not be null");
        }
        return this.realAdd(part, 0, part.length);
    }

    public Saph add(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            throw new IllegalArgumentException("Part may not be null");
        }
        return this.realAdd(buffer, offset, length);
    }

    private Saph realAdd(byte[] buffer, int offset, int length) {
        if (this.calculated) {
            throw new IllegalStateException("Parts can not be added to a calculated hash");
        }
        this.partsMd.reset();
        this.partsMd.update(buffer, offset, length);
        try {
            this.partsMd.digest(this.hashBuffer, 0, 32);
        }
        catch (DigestException ex) {
            throw new RuntimeException("Unexpected digest exception", ex);
        }
        this.currentMd.update(this.hashBuffer);
        return this;
    }

    public Saph add(ByteBuffer part) {
        if (part == null) {
            throw new IllegalArgumentException("Part may not be null");
        }
        if (this.calculated) {
            throw new IllegalStateException("Parts can not be added to a calculated hash");
        }
        this.partsMd.update(part);
        try {
            this.partsMd.digest(this.hashBuffer, 0, 32);
        }
        catch (DigestException ex) {
            throw new RuntimeException("Unexpected digest exception", ex);
        }
        this.currentMd.update(this.hashBuffer);
        return this;
    }

    public byte[] hash() {
        if (!this.calculated) {
            this.calculateHash();
            this.calculated = true;
        }
        return this.hashBuffer;
    }

    private void calculateHash() {
        Cipher cipher;
        try {
            this.currentMd.digest(this.hashBuffer, 0, 32);
        }
        catch (DigestException ex) {
            throw new RuntimeException("Unexpected digest exception", ex);
        }
        byte[] memory = new byte[this.memorySize * 64];
        int[] order = new int[this.memorySize];
        try {
            cipher = Cipher.getInstance("AES/CBC/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException ex) {
            throw new RuntimeException("Failed to initialize AES-128-CBC cipher (non-compliant JVM?)", ex);
        }
        for (int iteration = 0; iteration < this.iterations; ++iteration) {
            int i;
            SecretKeySpec key = new SecretKeySpec(this.hashBuffer, 0, 16, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.hashBuffer, 16, 16);
            try {
                cipher.init(1, (Key)key, iv);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException ex) {
                throw new RuntimeException("Failed to initialized cipher, somehow", ex);
            }
            try {
                cipher.update(memory, 0, memory.length, memory);
            }
            catch (ShortBufferException ex) {
                throw new RuntimeException("Cipher asked for a larger output than input (?)", ex);
            }
            for (i = 0; i < order.length; ++i) {
                order[i] = i;
            }
            i = 0;
            int iPos = 0;
            while (i < order.length) {
                long jLong = Byte.toUnsignedLong(memory[iPos]) | Byte.toUnsignedLong(memory[iPos + 1]) << 8 | Byte.toUnsignedLong(memory[iPos + 2]) << 16 | Byte.toUnsignedLong(memory[iPos + 3]) << 24;
                int j = (int)(jLong % (long)this.memorySize);
                int x = order[i];
                order[i] = order[j];
                order[j] = x;
                ++i;
                iPos += 64;
            }
            this.currentMd.reset();
            for (i = 0; i < order.length; ++i) {
                int pos = order[i] * 64;
                this.currentMd.update(memory, pos, 64);
            }
            try {
                this.currentMd.digest(this.hashBuffer, 0, 32);
                continue;
            }
            catch (DigestException ex) {
                throw new RuntimeException("Unexpected digest exception", ex);
            }
        }
    }

    public int getMemorySize() {
        return this.memorySize;
    }

    public int getIterations() {
        return this.iterations;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public byte[] getHash() {
        if (!this.calculated) {
            throw new IllegalStateException("The hash has not been yet calculated");
        }
        return this.hashBuffer;
    }
}

