/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.lifecycle;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.gems.lifecycle.ReflectionLifecycleException;

public class ReflectionLifecycleStrategy
implements LifecycleStrategy,
Serializable {
    public void start(Object component) {
        this.invokeMethod(component, "start");
    }

    public void stop(Object component) {
        this.invokeMethod(component, "stop");
    }

    public void dispose(Object component) {
        this.invokeMethod(component, "dispose");
    }

    private void invokeMethod(Object component, String methodName) {
        if (component != null) {
            try {
                Method method = component.getClass().getMethod(methodName, new Class[0]);
                method.invoke(component, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionLifecycleException(methodName, e);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionLifecycleException(methodName, e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionLifecycleException(methodName, e);
            }
        }
    }
}

