/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.monitors;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.picocontainer.monitors.AbstractComponentMonitor;

public class CommonsLoggingComponentMonitor
extends AbstractComponentMonitor
implements Serializable {
    private Log log;

    public CommonsLoggingComponentMonitor() {
    }

    public CommonsLoggingComponentMonitor(Class logClass) {
        this(logClass.getName());
    }

    public CommonsLoggingComponentMonitor(String logName) {
        this(LogFactory.getLog((String)logName));
    }

    public CommonsLoggingComponentMonitor(Log log) {
        this.log = log;
    }

    public void instantiating(Constructor constructor) {
        Log log = this.getLog(constructor);
        if (log.isDebugEnabled()) {
            log.debug((Object)CommonsLoggingComponentMonitor.format((String)"PicoContainer: instantiating {0}", (Object[])new Object[]{constructor}));
        }
    }

    public void instantiated(Constructor constructor, long duration) {
        Log log = this.getLog(constructor);
        if (log.isDebugEnabled()) {
            log.debug((Object)CommonsLoggingComponentMonitor.format((String)"PicoContainer: instantiated {0} [{1} ms]", (Object[])new Object[]{constructor, new Long(duration)}));
        }
    }

    public void instantiationFailed(Constructor constructor, Exception e) {
        Log log = this.getLog(constructor);
        if (log.isWarnEnabled()) {
            log.warn((Object)CommonsLoggingComponentMonitor.format((String)"PicoContainer: instantiation failed: {0}, reason: {1}", (Object[])new Object[]{constructor, e.getMessage()}), (Throwable)e);
        }
    }

    public void invoking(Method method, Object instance) {
        Log log = this.getLog(method);
        if (log.isDebugEnabled()) {
            log.debug((Object)CommonsLoggingComponentMonitor.format((String)"PicoContainer: invoking {0} on {1}", (Object[])new Object[]{method, instance}));
        }
    }

    public void invoked(Method method, Object instance, long duration) {
        Log log = this.getLog(method);
        if (log.isDebugEnabled()) {
            log.debug((Object)CommonsLoggingComponentMonitor.format((String)"PicoContainer: invoked {0} on {1} [{2} ms]", (Object[])new Object[]{method, instance, new Long(duration)}));
        }
    }

    public void invocationFailed(Method method, Object instance, Exception e) {
        Log log = this.getLog(method);
        if (log.isWarnEnabled()) {
            log.warn((Object)CommonsLoggingComponentMonitor.format((String)"PicoContainer: invocation failed: {0} on {1}, reason: {2}", (Object[])new Object[]{method, instance, e.getMessage()}), (Throwable)e);
        }
    }

    protected Log getLog(Member member) {
        if (this.log != null) {
            return this.log;
        }
        return LogFactory.getLog(member.getDeclaringClass());
    }
}

