/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.monitors;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.picocontainer.monitors.AbstractComponentMonitor;

public class Log4JComponentMonitor
extends AbstractComponentMonitor
implements Serializable {
    private Logger logger;

    public Log4JComponentMonitor() {
    }

    public Log4JComponentMonitor(Class loggerClass) {
        this(loggerClass.getName());
    }

    public Log4JComponentMonitor(String loggerName) {
        this(LogManager.getLogger((String)loggerName));
    }

    public Log4JComponentMonitor(Logger logger) {
        this.logger = logger;
    }

    public void instantiating(Constructor constructor) {
        Logger logger = this.getLogger(constructor);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Log4JComponentMonitor.format((String)"PicoContainer: instantiating {0}", (Object[])new Object[]{constructor}));
        }
    }

    public void instantiated(Constructor constructor, long duration) {
        Logger logger = this.getLogger(constructor);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Log4JComponentMonitor.format((String)"PicoContainer: instantiated {0} [{1} ms]", (Object[])new Object[]{constructor, new Long(duration)}));
        }
    }

    public void instantiationFailed(Constructor constructor, Exception e) {
        Logger logger = this.getLogger(constructor);
        if (logger.isEnabledFor(Priority.WARN)) {
            logger.warn((Object)Log4JComponentMonitor.format((String)"PicoContainer: instantiation failed: {0}, reason: {1}", (Object[])new Object[]{constructor, e.getMessage()}), (Throwable)e);
        }
    }

    public void invoking(Method method, Object instance) {
        Logger logger = this.getLogger(method);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Log4JComponentMonitor.format((String)"PicoContainer: invoking {0} on {1}", (Object[])new Object[]{method, instance}));
        }
    }

    public void invoked(Method method, Object instance, long duration) {
        Logger logger = this.getLogger(method);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Log4JComponentMonitor.format((String)"PicoContainer: invoked {0} on {1} [{2} ms]", (Object[])new Object[]{method, instance, new Long(duration)}));
        }
    }

    public void invocationFailed(Method method, Object instance, Exception e) {
        Logger logger = this.getLogger(method);
        if (logger.isEnabledFor(Priority.WARN)) {
            logger.warn((Object)Log4JComponentMonitor.format((String)"PicoContainer: invocation failed: {0} on {1}, reason: {2}", (Object[])new Object[]{method, instance, e.getMessage()}), (Throwable)e);
        }
    }

    protected Logger getLogger(Member member) {
        if (this.logger != null) {
            return this.logger;
        }
        return LogManager.getLogger(member.getDeclaringClass());
    }
}

