/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.lifecycle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.defaults.AbstractMonitoringLifecycleStrategy;
import org.picocontainer.gems.lifecycle.ReflectionLifecycleException;

public class ReflectionLifecycleStrategy
extends AbstractMonitoringLifecycleStrategy {
    private static final int START = 0;
    private static final int STOP = 1;
    private static final int DISPOSE = 2;
    private String[] methodNames;
    private final transient Map methodMap = new HashMap();

    public ReflectionLifecycleStrategy(ComponentMonitor monitor) {
        this(monitor, "start", "stop", "dispose");
    }

    public ReflectionLifecycleStrategy(ComponentMonitor monitor, String startMethodName, String stopMethodName, String disposeMethodName) {
        super(monitor);
        this.methodNames = new String[]{startMethodName, stopMethodName, disposeMethodName};
    }

    public void start(Object component) {
        Method[] methods = this.init(component.getClass());
        this.invokeMethod(component, methods[0]);
    }

    public void stop(Object component) {
        Method[] methods = this.init(component.getClass());
        this.invokeMethod(component, methods[1]);
    }

    public void dispose(Object component) {
        Method[] methods = this.init(component.getClass());
        this.invokeMethod(component, methods[2]);
    }

    private void invokeMethod(Object component, Method method) {
        if (component != null && method != null) {
            try {
                long str = System.currentTimeMillis();
                this.currentMonitor().invoking(method, component);
                method.invoke(component, new Object[0]);
                this.currentMonitor().invoked(method, component, System.currentTimeMillis() - str);
            }
            catch (IllegalAccessException e) {
                ReflectionLifecycleException re = new ReflectionLifecycleException(method.getName(), e);
                this.currentMonitor().lifecycleInvocationFailed(method, component, (RuntimeException)((Object)re));
                throw re;
            }
            catch (InvocationTargetException e) {
                ReflectionLifecycleException re = new ReflectionLifecycleException(method.getName(), e);
                this.currentMonitor().lifecycleInvocationFailed(method, component, (RuntimeException)((Object)re));
                throw re;
            }
        }
    }

    public boolean hasLifecycle(Class type) {
        Method[] methods = this.init(type);
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i] == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method[] init(Class type) {
        Method[] methods;
        Map map = this.methodMap;
        synchronized (map) {
            methods = (Method[])this.methodMap.get(type);
            if (methods == null) {
                methods = new Method[this.methodNames.length];
                for (int i = 0; i < methods.length; ++i) {
                    try {
                        methods[i] = type.getMethod(this.methodNames[i], new Class[0]);
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
                this.methodMap.put(type, methods);
            }
        }
        return methods;
    }
}

