/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.monitors;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.monitors.AbstractComponentMonitor;
import org.picocontainer.monitors.DefaultComponentMonitor;

public class CommonsLoggingComponentMonitor
extends AbstractComponentMonitor
implements Serializable {
    private Log log;
    private final ComponentMonitor delegate;

    public CommonsLoggingComponentMonitor() {
        this.delegate = new DefaultComponentMonitor();
    }

    public CommonsLoggingComponentMonitor(Class logClass) {
        this(logClass.getName());
    }

    public CommonsLoggingComponentMonitor(String logName) {
        this(LogFactory.getLog((String)logName));
    }

    public CommonsLoggingComponentMonitor(Log log) {
        this();
        this.log = log;
    }

    public CommonsLoggingComponentMonitor(Class logClass, ComponentMonitor delegate) {
        this(logClass.getName(), delegate);
    }

    public CommonsLoggingComponentMonitor(String logName, ComponentMonitor delegate) {
        this(LogFactory.getLog((String)logName), delegate);
    }

    public CommonsLoggingComponentMonitor(Log log, ComponentMonitor delegate) {
        this.log = log;
        this.delegate = delegate;
    }

    public void instantiating(Constructor constructor) {
        Log log = this.getLog(constructor);
        if (log.isDebugEnabled()) {
            log.debug((Object)CommonsLoggingComponentMonitor.format((String)"PicoContainer: instantiating {0}", (Object[])new Object[]{constructor}));
        }
        this.delegate.instantiating(constructor);
    }

    public void instantiated(Constructor constructor, long duration) {
        Log log = this.getLog(constructor);
        if (log.isDebugEnabled()) {
            log.debug((Object)CommonsLoggingComponentMonitor.format((String)"PicoContainer: instantiated {0} [{1} ms]", (Object[])new Object[]{constructor, new Long(duration)}));
        }
        this.delegate.instantiated(constructor, duration);
    }

    public void instantiationFailed(Constructor constructor, Exception cause) {
        Log log = this.getLog(constructor);
        if (log.isWarnEnabled()) {
            log.warn((Object)CommonsLoggingComponentMonitor.format((String)"PicoContainer: instantiation failed: {0}, reason: {1}", (Object[])new Object[]{constructor, cause.getMessage()}), (Throwable)cause);
        }
        this.delegate.instantiationFailed(constructor, cause);
    }

    public void invoking(Method method, Object instance) {
        Log log = this.getLog(method);
        if (log.isDebugEnabled()) {
            log.debug((Object)CommonsLoggingComponentMonitor.format((String)"PicoContainer: invoking {0} on {1}", (Object[])new Object[]{method, instance}));
        }
        this.delegate.invoking(method, instance);
    }

    public void invoked(Method method, Object instance, long duration) {
        Log log = this.getLog(method);
        if (log.isDebugEnabled()) {
            log.debug((Object)CommonsLoggingComponentMonitor.format((String)"PicoContainer: invoked {0} on {1} [{2} ms]", (Object[])new Object[]{method, instance, new Long(duration)}));
        }
        this.delegate.invoked(method, instance, duration);
    }

    public void invocationFailed(Method method, Object instance, Exception cause) {
        Log log = this.getLog(method);
        if (log.isWarnEnabled()) {
            log.warn((Object)CommonsLoggingComponentMonitor.format((String)"PicoContainer: invocation failed: {0} on {1}, reason: {2}", (Object[])new Object[]{method, instance, cause.getMessage()}), (Throwable)cause);
        }
        this.delegate.invocationFailed(method, instance, cause);
    }

    public void lifecycleInvocationFailed(Method method, Object instance, RuntimeException cause) {
        Log log = this.getLog(method);
        if (log.isWarnEnabled()) {
            log.warn((Object)CommonsLoggingComponentMonitor.format((String)"PicoContainer: lifecycle invocation failed: {0} on {1}, reason: {2}", (Object[])new Object[]{method, instance, cause.getMessage()}), (Throwable)cause);
        }
        this.delegate.lifecycleInvocationFailed(method, instance, cause);
    }

    protected Log getLog(Member member) {
        if (this.log != null) {
            return this.log;
        }
        return LogFactory.getLog(member.getDeclaringClass());
    }
}

