/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.gems.monitors;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.monitors.AbstractComponentMonitor;
import org.picocontainer.monitors.DefaultComponentMonitor;

public class Log4JComponentMonitor
extends AbstractComponentMonitor
implements Serializable {
    private Logger logger;
    private final ComponentMonitor delegate;

    public Log4JComponentMonitor() {
        this.delegate = new DefaultComponentMonitor();
    }

    public Log4JComponentMonitor(Class loggerClass) {
        this(loggerClass.getName());
    }

    public Log4JComponentMonitor(String loggerName) {
        this(LogManager.getLogger((String)loggerName));
    }

    public Log4JComponentMonitor(Logger logger) {
        this();
        this.logger = logger;
    }

    public Log4JComponentMonitor(Class loggerClass, ComponentMonitor delegate) {
        this(loggerClass.getName(), delegate);
    }

    public Log4JComponentMonitor(String loggerName, ComponentMonitor delegate) {
        this(LogManager.getLogger((String)loggerName), delegate);
    }

    public Log4JComponentMonitor(Logger logger, ComponentMonitor delegate) {
        this(delegate);
        this.logger = logger;
    }

    public Log4JComponentMonitor(ComponentMonitor delegate) {
        this.delegate = delegate;
    }

    public void instantiating(Constructor constructor) {
        Logger logger = this.getLogger(constructor);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Log4JComponentMonitor.format((String)"PicoContainer: instantiating {0}", (Object[])new Object[]{constructor}));
        }
        this.delegate.instantiating(constructor);
    }

    public void instantiated(Constructor constructor, long duration) {
        Logger logger = this.getLogger(constructor);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Log4JComponentMonitor.format((String)"PicoContainer: instantiated {0} [{1} ms]", (Object[])new Object[]{constructor, new Long(duration)}));
        }
        this.delegate.instantiated(constructor, duration);
    }

    public void instantiationFailed(Constructor constructor, Exception cause) {
        Logger logger = this.getLogger(constructor);
        if (logger.isEnabledFor(Priority.WARN)) {
            logger.warn((Object)Log4JComponentMonitor.format((String)"PicoContainer: instantiation failed: {0}, reason: {1}", (Object[])new Object[]{constructor, cause.getMessage()}), (Throwable)cause);
        }
        this.delegate.instantiationFailed(constructor, cause);
    }

    public void invoking(Method method, Object instance) {
        Logger logger = this.getLogger(method);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Log4JComponentMonitor.format((String)"PicoContainer: invoking {0} on {1}", (Object[])new Object[]{method, instance}));
        }
        this.delegate.invoking(method, instance);
    }

    public void invoked(Method method, Object instance, long duration) {
        Logger logger = this.getLogger(method);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Log4JComponentMonitor.format((String)"PicoContainer: invoked {0} on {1} [{2} ms]", (Object[])new Object[]{method, instance, new Long(duration)}));
        }
        this.delegate.invoked(method, instance, duration);
    }

    public void invocationFailed(Method method, Object instance, Exception cause) {
        Logger logger = this.getLogger(method);
        if (logger.isEnabledFor(Priority.WARN)) {
            logger.warn((Object)Log4JComponentMonitor.format((String)"PicoContainer: invocation failed: {0} on {1}, reason: {2}", (Object[])new Object[]{method, instance, cause.getMessage()}), (Throwable)cause);
        }
        this.delegate.invocationFailed(method, instance, cause);
    }

    public void lifecycleInvocationFailed(Method method, Object instance, RuntimeException cause) {
        Logger logger = this.getLogger(method);
        if (logger.isEnabledFor(Priority.WARN)) {
            logger.warn((Object)Log4JComponentMonitor.format((String)"PicoContainer: lifecycle invocation failed: {0} on {1}, reason: {2}", (Object[])new Object[]{method, instance, cause.getMessage()}), (Throwable)cause);
        }
        this.delegate.lifecycleInvocationFailed(method, instance, cause);
    }

    protected Logger getLogger(Member member) {
        if (this.logger != null) {
            return this.logger;
        }
        return LogManager.getLogger(member.getDeclaringClass());
    }
}

