/**
   Copyright (c) 2011, the SemanticVectors AUTHORS.

   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   * Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   * Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.

   * Neither the name of the University of Pittsburgh nor the names
   of its contributors may be used to endorse or promote products
   derived from this software without specific prior written
   permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**/

package pitt.search.semanticvectors.vectors;

/**
 * Exception indicating an attempt to combine vectors of different types or dimension.
 * 
 * @author Dominic Widdows
 */
public class IncompatibleVectorsException extends RuntimeException {
  public IncompatibleVectorsException() {
    super();
  }

  public IncompatibleVectorsException(String message) {
    super(message + "\nThis almost certainly indicates a programming error!");
  }
  
  public static void checkVectorsCompatible(Vector first, Vector second) {
    if (first == null) throw new NullPointerException("first vector cannot be null");
    if (second == null) throw new NullPointerException("second vector cannot be null");
    
    if (first.getClass() != second.getClass()) {
      throw new IncompatibleVectorsException("Trying to combine vectors of type: "
          + first.getClass().getCanonicalName() + ", " + second.getClass().getCanonicalName());
    }
    if (first.getDimension() != second.getDimension()) {
      throw new IncompatibleVectorsException("Trying to combine vectors of dimension: "
          + first.getDimension() + ", " + second.getDimension());
    }
  }
}
