/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal;

import pl.allegro.finance.tradukisto.internal.BaseValues;
import pl.allegro.finance.tradukisto.internal.BigDecimalToStringConverter;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.converters.BigDecimalToBankingMoneyConverter;
import pl.allegro.finance.tradukisto.internal.converters.HundredsToWordsConverter;
import pl.allegro.finance.tradukisto.internal.converters.IntegerToWordsConverter;
import pl.allegro.finance.tradukisto.internal.languages.czech.CzechIntegerToWordsConverter;
import pl.allegro.finance.tradukisto.internal.languages.czech.CzechValues;
import pl.allegro.finance.tradukisto.internal.languages.czech.CzechValuesForSmallNumbers;
import pl.allegro.finance.tradukisto.internal.languages.english.EnglishValues;
import pl.allegro.finance.tradukisto.internal.languages.german.GermanIntegerToWordsConverter;
import pl.allegro.finance.tradukisto.internal.languages.german.GermanThousandToWordsConverter;
import pl.allegro.finance.tradukisto.internal.languages.german.GermanValues;
import pl.allegro.finance.tradukisto.internal.languages.polish.PolishValues;
import pl.allegro.finance.tradukisto.internal.languages.portuguese.BrazilianPortugueseValues;
import pl.allegro.finance.tradukisto.internal.languages.portuguese.PortugueseIntegerToWordsConverter;
import pl.allegro.finance.tradukisto.internal.languages.portuguese.PortugueseIntegerToWordsConverterAdapter;
import pl.allegro.finance.tradukisto.internal.languages.portuguese.PortugueseThousandToWordsConverter;
import pl.allegro.finance.tradukisto.internal.languages.russian.RussianValues;

public final class Container {
    private final IntegerToStringConverter integerConverter;
    private final BigDecimalToStringConverter bigDecimalConverter;

    public static Container polishContainer() {
        return new Container(new PolishValues());
    }

    public static Container russianContainer() {
        return new Container(new RussianValues());
    }

    public static Container czechContainer() {
        CzechValues czechValues = new CzechValues();
        Container containerForBigNumbers = new Container(czechValues);
        Container containerForSmallNumbers = new Container(new CzechValuesForSmallNumbers());
        CzechIntegerToWordsConverter integerConverter = new CzechIntegerToWordsConverter(containerForBigNumbers.getNumbersConverter(), containerForSmallNumbers.getNumbersConverter(), czechValues.exceptions());
        BigDecimalToBankingMoneyConverter bigDecimalBankingMoneyValueConverter = new BigDecimalToBankingMoneyConverter(integerConverter, czechValues.currency());
        return new Container(integerConverter, bigDecimalBankingMoneyValueConverter);
    }

    public static Container englishContainer() {
        return new Container(new EnglishValues());
    }

    public static Container germanContainer() {
        GermanValues values = new GermanValues();
        GermanThousandToWordsConverter germanThousandToWordsConverter = new GermanThousandToWordsConverter(values.baseNumbers());
        GermanIntegerToWordsConverter converter = new GermanIntegerToWordsConverter(new IntegerToWordsConverter(germanThousandToWordsConverter, values.pluralForms()), values.exceptions(), germanThousandToWordsConverter);
        BigDecimalToBankingMoneyConverter bigDecimalBankingMoneyValueConverter = new BigDecimalToBankingMoneyConverter(converter, values.currency());
        return new Container(converter, bigDecimalBankingMoneyValueConverter);
    }

    public static Container brazilianPortugueseContainer() {
        BrazilianPortugueseValues values = new BrazilianPortugueseValues();
        PortugueseThousandToWordsConverter portugueseThousandToWordsConverter = new PortugueseThousandToWordsConverter(values.baseNumbers(), values.exceptions());
        PortugueseIntegerToWordsConverter converter = new PortugueseIntegerToWordsConverter(new PortugueseIntegerToWordsConverterAdapter(portugueseThousandToWordsConverter, values.pluralForms()), values.exceptions(), portugueseThousandToWordsConverter);
        BigDecimalToBankingMoneyConverter bigDecimalBankingMoneyValueConverter = new BigDecimalToBankingMoneyConverter(converter, values.currency());
        return new Container(converter, bigDecimalBankingMoneyValueConverter);
    }

    private Container(BaseValues baseValues) {
        HundredsToWordsConverter hundredsToStringConverter = new HundredsToWordsConverter(baseValues.baseNumbers(), baseValues.twoDigitsNumberSeparator());
        this.integerConverter = new IntegerToWordsConverter(hundredsToStringConverter, baseValues.pluralForms());
        this.bigDecimalConverter = new BigDecimalToBankingMoneyConverter(this.integerConverter, baseValues.currency());
    }

    private Container(IntegerToStringConverter integerConverter, BigDecimalToStringConverter bigDecimalConverter) {
        this.integerConverter = integerConverter;
        this.bigDecimalConverter = bigDecimalConverter;
    }

    public IntegerToStringConverter getNumbersConverter() {
        return this.integerConverter;
    }

    public BigDecimalToStringConverter getBankingMoneyConverter() {
        return this.bigDecimalConverter;
    }
}

