/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.converters;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pl.allegro.finance.tradukisto.internal.GenderAwareIntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.ToStringConverter;
import pl.allegro.finance.tradukisto.internal.languages.PluralForms;
import pl.allegro.finance.tradukisto.internal.support.NumberChunking;

public class IntegerToWordsConverter
implements IntegerToStringConverter {
    private final NumberChunking numberChunking = new NumberChunking();
    protected final GenderAwareIntegerToStringConverter hundredsToWordsConverter;
    private final List<PluralForms> pluralForms;

    public IntegerToWordsConverter(GenderAwareIntegerToStringConverter hundredsToWordsConverter, List<PluralForms> pluralForms) {
        this.hundredsToWordsConverter = hundredsToWordsConverter;
        this.pluralForms = pluralForms;
    }

    public IntegerToWordsConverter(IntegerToStringConverter hundredsToWordsConverter, List<PluralForms> pluralForms) {
        this.hundredsToWordsConverter = ToStringConverter.toGenderAwareInteger(hundredsToWordsConverter);
        this.pluralForms = pluralForms;
    }

    @Override
    public String asWords(Integer value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (String)"can't convert negative numbers for value %d", (Object)value);
        List<Integer> valueChunks = this.numberChunking.chunk(value);
        List formsToUse = Lists.reverse(this.pluralForms.subList(0, valueChunks.size()));
        return this.joinValueChunksWithForms(valueChunks.iterator(), formsToUse.iterator());
    }

    protected String joinValueChunksWithForms(Iterator<Integer> chunks, Iterator<PluralForms> formsToUse) {
        ArrayList<String> result = new ArrayList<String>();
        while (chunks.hasNext() && formsToUse.hasNext()) {
            Integer currentChunkValue = chunks.next();
            PluralForms currentForms = formsToUse.next();
            if (currentChunkValue <= 0) continue;
            result.add(this.hundredsToWordsConverter.asWords(currentChunkValue, currentForms.genderType()));
            result.add(currentForms.formFor(currentChunkValue));
        }
        return this.joinParts(result);
    }

    protected String joinParts(List<String> result) {
        if (result.size() == 0) {
            return this.hundredsToWordsConverter.asWords(0, this.pluralForms.get(0).genderType());
        }
        return Joiner.on((String)" ").join(result).trim();
    }
}

