/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto;

import com.google.common.base.Verify;
import java.math.BigDecimal;
import pl.allegro.finance.tradukisto.internal.BigDecimalToStringConverter;
import pl.allegro.finance.tradukisto.internal.Container;

public enum MoneyConverters {
    BRAZILIAN_PORTUGUESE_BANKING_MONEY_VALUE(Container.brazilianPortugueseContainer().getBankingMoneyConverter()),
    ENGLISH_BANKING_MONEY_VALUE(Container.englishContainer().getBankingMoneyConverter()),
    GERMAN_BANKING_MONEY_VALUE(Container.germanContainer().getBankingMoneyConverter()),
    RUSSIAN_BANKING_MONEY_VALUE(Container.russianContainer().getBankingMoneyConverter()),
    POLISH_BANKING_MONEY_VALUE(Container.polishContainer().getBankingMoneyConverter()),
    ITALIAN_BANKING_MONEY_VALUE(Container.italianContainer().getBankingMoneyConverter()),
    CZECH_BANKING_MONEY_VALUE(Container.czechContainer().getBankingMoneyConverter()),
    SLOVAK_BANKING_MONEY_VALUE(Container.slovakContainer().getBankingMoneyConverter()),
    LATVIAN_BANKING_MONEY_VALUE(Container.latvianContainer().getBankingMoneyConverter()),
    KAZAKH_BANKING_MONEY_VALUE(Container.kazakhContainer().getBankingMoneyConverter()),
    UKRAINIAN_BANKING_MONEY_VALUE(Container.ukrainianContainer().getBankingMoneyConverter()),
    TURKISH_BANKING_MONEY_VALUE(Container.turkishContainer().getBankingMoneyConverter()),
    SERBIAN_BANKING_MONEY_VALUE(Container.serbianContainer().getBankingMoneyConverter()),
    FRENCH_BANKING_MONEY_VALUE(Container.frenchContainer().getBankingMoneyConverter());

    private final BigDecimalToStringConverter converter;

    private MoneyConverters(BigDecimalToStringConverter converter) {
        this.converter = converter;
    }

    public String asWords(BigDecimal value) {
        Verify.verifyNotNull((Object)value);
        return this.converter.asWords(value);
    }
}

