/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto;

import com.google.common.base.Verify;
import pl.allegro.finance.tradukisto.internal.Container;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;

public enum ValueConverters {
    BRAZILIAN_PORTUGUESE_INTEGER(Container.brazilianPortugueseContainer().getNumbersConverter()),
    ENGLISH_INTEGER(Container.englishContainer().getNumbersConverter()),
    GERMAN_INTEGER(Container.germanContainer().getNumbersConverter()),
    RUSSIAN_INTEGER(Container.russianContainer().getNumbersConverter()),
    ITALIAN_INTEGER(Container.italianContainer().getNumbersConverter()),
    POLISH_INTEGER(Container.polishContainer().getNumbersConverter()),
    CZECH_INTEGER(Container.czechContainer().getNumbersConverter()),
    SLOVAK_INTEGER(Container.slovakContainer().getNumbersConverter()),
    LATVIAN_INTEGER(Container.latvianContainer().getNumbersConverter()),
    KAZAKH_INTEGER(Container.kazakhContainer().getNumbersConverter()),
    UKRAINIAN_INTEGER(Container.ukrainianContainer().getNumbersConverter()),
    SERBIAN_INTEGER(Container.serbianContainer().getNumbersConverter()),
    FRENCH_INTEGER(Container.frenchContainer().getNumbersConverter()),
    TURKISH_INTEGER(Container.turkishContainer().getNumbersConverter());

    private final IntegerToStringConverter converter;

    private ValueConverters(IntegerToStringConverter converter) {
        this.converter = converter;
    }

    public String asWords(Integer value) {
        Verify.verifyNotNull((Object)value);
        return this.converter.asWords(value);
    }
}

