/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.converters;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import pl.allegro.finance.tradukisto.internal.BigDecimalToStringConverter;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;

public class BigDecimalToBankingMoneyConverter
implements BigDecimalToStringConverter {
    private static final String FORMAT = "%s %s %02d/100";
    private static final int MAXIMAL_DECIMAL_PLACES_COUNT = 2;
    private final IntegerToStringConverter converter;
    private final String currencySymbol;

    public BigDecimalToBankingMoneyConverter(IntegerToStringConverter converter, String currencySymbol) {
        this.converter = converter;
        this.currencySymbol = currencySymbol;
    }

    @Override
    public String asWords(BigDecimal value) {
        this.validate(value);
        Integer units = value.intValue();
        Integer subunits = value.remainder(BigDecimal.ONE).multiply(new BigDecimal(100)).intValue();
        return String.format(FORMAT, this.converter.asWords(units), this.currencySymbol, subunits);
    }

    private void validate(BigDecimal value) {
        Preconditions.checkArgument((value.scale() <= 2 ? 1 : 0) != 0, (String)"can't transform more than %s decimal places for value %s", (int)2, (Object)value);
        Preconditions.checkArgument((boolean)this.valueLessThatIntMax(value), (String)"can't transform numbers greater than Integer.MAX_VALUE for value %s", (Object)value);
        Preconditions.checkArgument((boolean)this.valueGreaterThanOrEqualToZero(value), (String)"can't transform negative numbers for value %s", (Object)value);
    }

    private boolean valueLessThatIntMax(BigDecimal value) {
        return value.compareTo(new BigDecimal(Integer.MAX_VALUE).add(BigDecimal.ONE)) == -1;
    }

    private boolean valueGreaterThanOrEqualToZero(BigDecimal value) {
        return value.signum() >= 0;
    }
}

