/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import pl.allegro.finance.tradukisto.internal.languages.GenderType;
import pl.allegro.finance.tradukisto.internal.languages.MissingFormException;

public class GenderForms {
    private final Map<GenderType, String> forms;

    public static GenderForms genderForms(String masculineForm, String feminineForm, String neuterForm) {
        return new GenderForms(masculineForm, feminineForm, neuterForm);
    }

    public static GenderForms genderForms(String masculineForm, String feminineForm, String neuterForm, String nonApplicableForm) {
        return new GenderForms(masculineForm, feminineForm, neuterForm, nonApplicableForm);
    }

    public static GenderForms genderForm(String nonApplicableForm) {
        return new GenderForms(nonApplicableForm);
    }

    public GenderForms(String masculineForm, String feminineForm, String neuterForm) {
        this.forms = ImmutableMap.builder().put((Object)GenderType.MASCULINE, (Object)masculineForm).put((Object)GenderType.FEMININE, (Object)feminineForm).put((Object)GenderType.NEUTER, (Object)neuterForm).build();
    }

    public GenderForms(String masculineForm, String feminineForm, String neuterForm, String nonApplicableForm) {
        this.forms = ImmutableMap.builder().put((Object)GenderType.MASCULINE, (Object)masculineForm).put((Object)GenderType.FEMININE, (Object)feminineForm).put((Object)GenderType.NEUTER, (Object)neuterForm).put((Object)GenderType.NON_APPLICABLE, (Object)nonApplicableForm).build();
    }

    public GenderForms(String nonApplicableForm) {
        this.forms = ImmutableMap.builder().put((Object)GenderType.MASCULINE, (Object)nonApplicableForm).put((Object)GenderType.FEMININE, (Object)nonApplicableForm).put((Object)GenderType.NEUTER, (Object)nonApplicableForm).put((Object)GenderType.NON_APPLICABLE, (Object)nonApplicableForm).build();
    }

    public String formFor(GenderType gender) {
        this.validate(gender);
        return this.forms.get((Object)gender);
    }

    private void validate(GenderType gender) {
        if (!this.forms.containsKey((Object)gender)) {
            throw new MissingFormException(String.format("No form found for %s. Available forms: %s", new Object[]{gender, this.forms}));
        }
    }
}

