/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import pl.allegro.finance.tradukisto.internal.Container;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.support.Assert;

public enum ValueConverters {
    BRAZILIAN_PORTUGUESE_INTEGER(Container.brazilianPortugueseContainer().getIntegerConverter(), Arrays.asList("pt", "pt-br")),
    ENGLISH_INTEGER(Container.englishContainer().getIntegerConverter(), "en"),
    GERMAN_INTEGER(Container.germanContainer().getIntegerConverter(), "de"),
    RUSSIAN_INTEGER(Container.russianContainer().getIntegerConverter(), "ru"),
    ITALIAN_INTEGER(Container.italianContainer().getIntegerConverter(), "it"),
    POLISH_INTEGER(Container.polishContainer().getIntegerConverter(), "pl"),
    CZECH_INTEGER(Container.czechContainer().getIntegerConverter(), "cs"),
    SLOVAK_INTEGER(Container.slovakContainer().getIntegerConverter(), "sk"),
    LATVIAN_INTEGER(Container.latvianContainer().getIntegerConverter(), "lv"),
    KAZAKH_INTEGER(Container.kazakhContainer().getIntegerConverter(), "kk"),
    UKRAINIAN_INTEGER(Container.ukrainianContainer().getIntegerConverter(), "uk"),
    SERBIAN_INTEGER(Container.serbianContainer().getIntegerConverter(), Arrays.asList("sr", ValueConverters.getLanguageCodeFor("sr", "Latn"))),
    SERBIAN_CYRILLIC_INTEGER(Container.serbianCyrillicContainer().getIntegerConverter(), ValueConverters.getLanguageCodeFor("sr", "Cyrl")),
    BULGARIAN_INTEGER(Container.bulgarianContainer().getIntegerConverter(), "bg"),
    FRENCH_INTEGER(Container.frenchContainer().getIntegerConverter(), "fr"),
    TURKISH_INTEGER(Container.turkishContainer().getIntegerConverter(), "tr");

    private final IntegerToStringConverter converter;
    private final List<String> languageCodes;

    private ValueConverters(IntegerToStringConverter converter, String languageCodes) {
        this(converter, Collections.singletonList(languageCodes));
    }

    private ValueConverters(IntegerToStringConverter converter, List<String> languageCodes) {
        this.converter = converter;
        this.languageCodes = languageCodes;
    }

    public static ValueConverters getByLocaleOrDefault(Locale locale, ValueConverters defaultConverter) {
        Objects.requireNonNull(locale);
        String languageCode = ValueConverters.hasSpecifiedScript(locale) ? ValueConverters.getLanguageCodeFor(locale.getLanguage(), locale.getScript()) : locale.getLanguage();
        return ValueConverters.getByLanguageCodeOrDefault(languageCode, defaultConverter);
    }

    public static ValueConverters getByLanguageCodeOrDefault(String languageCode, ValueConverters defaultConverter) {
        Objects.requireNonNull(languageCode);
        Assert.isFalse(languageCode.isEmpty());
        return Arrays.stream(ValueConverters.values()).filter(it -> it.languageCodes.contains(languageCode)).findFirst().orElse(defaultConverter);
    }

    private static boolean hasSpecifiedScript(Locale locale) {
        return !locale.getScript().isEmpty();
    }

    private static String getLanguageCodeFor(String language, String script) {
        return new Locale.Builder().setLanguage(language).setScript(script).build().toString();
    }

    public String asWords(Integer value) {
        Objects.requireNonNull(value);
        return this.converter.asWords(value);
    }
}

