/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.converters;

import java.util.Map;
import pl.allegro.finance.tradukisto.internal.GenderAwareIntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.languages.GenderForms;
import pl.allegro.finance.tradukisto.internal.languages.GenderType;
import pl.allegro.finance.tradukisto.internal.support.Range;

public class HundredsToWordsConverter
implements GenderAwareIntegerToStringConverter {
    private final Map<Integer, GenderForms> baseValues;
    private final char twoDigitsNumberSeparator;

    public HundredsToWordsConverter(Map<Integer, GenderForms> baseValues, char twoDigitsNumberSeparator) {
        this.baseValues = baseValues;
        this.twoDigitsNumberSeparator = twoDigitsNumberSeparator;
    }

    @Override
    public String asWords(Integer value, GenderType genderType) {
        if (this.baseValues.containsKey(value)) {
            return this.baseValues.get(value).formFor(genderType);
        }
        if (Range.closed(21, 99).contains(value)) {
            return this.twoDigitsNumberAsString(value, genderType);
        }
        if (Range.closed(101, 999).contains(value)) {
            return this.threeDigitsNumberAsString(value, genderType);
        }
        throw new IllegalArgumentException(String.format("Can't convert %d", value));
    }

    private String twoDigitsNumberAsString(Integer value, GenderType genderType) {
        Integer units = value % 10;
        Integer tens = value - units;
        return String.format("%s%c%s", this.asWords(tens, genderType), Character.valueOf(this.twoDigitsNumberSeparator), this.asWords(units, genderType));
    }

    private String threeDigitsNumberAsString(Integer value, GenderType genderType) {
        Integer tensWithUnits = value % 100;
        Integer hundreds = value - tensWithUnits;
        return String.format("%s %s", this.asWords(hundreds, genderType), this.asWords(tensWithUnits, genderType));
    }
}

