/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.converters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pl.allegro.finance.tradukisto.internal.GenderAwareIntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.LongToStringConverter;
import pl.allegro.finance.tradukisto.internal.ToStringConverter;
import pl.allegro.finance.tradukisto.internal.languages.PluralForms;
import pl.allegro.finance.tradukisto.internal.support.Assert;
import pl.allegro.finance.tradukisto.internal.support.NumberChunking;

public class NumberToWordsConverter
implements IntegerToStringConverter,
LongToStringConverter {
    private final NumberChunking numberChunking = new NumberChunking();
    protected final GenderAwareIntegerToStringConverter hundredsToWordsConverter;
    private final List<PluralForms> pluralForms;

    public NumberToWordsConverter(GenderAwareIntegerToStringConverter hundredsToWordsConverter, List<PluralForms> pluralForms) {
        this.hundredsToWordsConverter = hundredsToWordsConverter;
        this.pluralForms = pluralForms;
    }

    public NumberToWordsConverter(IntegerToStringConverter hundredsToWordsConverter, List<PluralForms> pluralForms) {
        this.hundredsToWordsConverter = ToStringConverter.toGenderAwareInteger(hundredsToWordsConverter);
        this.pluralForms = pluralForms;
    }

    @Override
    public String asWords(Integer value) {
        return this.asWords(value.longValue());
    }

    @Override
    public String asWords(Long value) {
        Assert.isTrue(value >= 0L, () -> String.format("can't convert negative numbers for value %d", value));
        List<Integer> valueChunks = this.numberChunking.chunk(value);
        List<PluralForms> formsToUse = this.getRequiredFormsInReversedOrder(valueChunks.size());
        return this.joinValueChunksWithForms(valueChunks.iterator(), formsToUse.iterator());
    }

    protected List<PluralForms> getRequiredFormsInReversedOrder(int chunks) {
        ArrayList<PluralForms> formsToUse = new ArrayList<PluralForms>(this.pluralForms.subList(0, chunks));
        Collections.reverse(formsToUse);
        return formsToUse;
    }

    protected String joinValueChunksWithForms(Iterator<Integer> chunks, Iterator<PluralForms> formsToUse) {
        ArrayList<String> result = new ArrayList<String>();
        while (chunks.hasNext() && formsToUse.hasNext()) {
            Integer currentChunkValue = chunks.next();
            PluralForms currentForms = formsToUse.next();
            if (currentChunkValue <= 0) continue;
            result.add(this.hundredsToWordsConverter.asWords(currentChunkValue, currentForms.genderType()));
            result.add(currentForms.formFor(currentChunkValue));
        }
        return this.joinParts(result);
    }

    protected String joinParts(List<String> result) {
        return result.isEmpty() ? this.hundredsToWordsConverter.asWords(0, this.pluralForms.get(0).genderType()) : String.join((CharSequence)" ", result).trim();
    }
}

