/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages;

import java.util.Map;
import pl.allegro.finance.tradukisto.internal.languages.GenderType;
import pl.allegro.finance.tradukisto.internal.languages.MissingFormException;
import pl.allegro.finance.tradukisto.internal.support.MapSupport;

public class GenderForms {
    private final Map<GenderType, String> forms;

    public static GenderForms genderForms(String masculineForm, String feminineForm, String neuterForm) {
        return new GenderForms(masculineForm, feminineForm, neuterForm);
    }

    public static GenderForms genderForms(String masculineForm, String feminineForm, String neuterForm, String nonApplicableForm) {
        return new GenderForms(masculineForm, feminineForm, neuterForm, nonApplicableForm);
    }

    public static GenderForms genderForm(String nonApplicableForm) {
        return new GenderForms(nonApplicableForm);
    }

    public GenderForms(String masculineForm, String feminineForm, String neuterForm) {
        this.forms = MapSupport.unmodifiableMapOf(MapSupport.unmodifiableEntry(GenderType.MASCULINE, masculineForm), MapSupport.unmodifiableEntry(GenderType.FEMININE, feminineForm), MapSupport.unmodifiableEntry(GenderType.NEUTER, neuterForm));
    }

    public GenderForms(String masculineForm, String feminineForm, String neuterForm, String nonApplicableForm) {
        this.forms = MapSupport.unmodifiableMapOf(MapSupport.unmodifiableEntry(GenderType.MASCULINE, masculineForm), MapSupport.unmodifiableEntry(GenderType.FEMININE, feminineForm), MapSupport.unmodifiableEntry(GenderType.NEUTER, neuterForm), MapSupport.unmodifiableEntry(GenderType.NON_APPLICABLE, nonApplicableForm));
    }

    public GenderForms(String nonApplicableForm) {
        this.forms = MapSupport.unmodifiableMapOf(MapSupport.unmodifiableEntry(GenderType.MASCULINE, nonApplicableForm), MapSupport.unmodifiableEntry(GenderType.FEMININE, nonApplicableForm), MapSupport.unmodifiableEntry(GenderType.NEUTER, nonApplicableForm), MapSupport.unmodifiableEntry(GenderType.NON_APPLICABLE, nonApplicableForm));
    }

    public String formFor(GenderType gender) {
        this.validate(gender);
        return this.forms.get((Object)gender);
    }

    private void validate(GenderType gender) {
        if (!this.forms.containsKey((Object)gender)) {
            throw new MissingFormException(String.format("No form found for %s. Available forms: %s", new Object[]{gender, this.forms}));
        }
    }
}

