/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.bulgarian;

import java.util.List;
import pl.allegro.finance.tradukisto.internal.converters.HundredsToWordsConverter;
import pl.allegro.finance.tradukisto.internal.converters.NumberToWordsConverter;
import pl.allegro.finance.tradukisto.internal.languages.PluralForms;

public class BulgarianIntegerToWordsConverter
extends NumberToWordsConverter {
    private final String oneThousand;
    private static final String MERGE_PATTERN = "%s %s";
    private static final int ONE_THOUSAND = 1000;
    private static final int TWO_THOUSAND = 2000;

    public BulgarianIntegerToWordsConverter(HundredsToWordsConverter hundredsToStringConverter, List<PluralForms> pluralForms, String oneThousand) {
        super(hundredsToStringConverter, pluralForms);
        this.oneThousand = oneThousand;
    }

    @Override
    public String asWords(Integer value) {
        if (value == 1000) {
            return this.oneThousand;
        }
        if (this.isBetweenOneThousandAndTwoThousand(value)) {
            int remainder = this.getNumbersSmallerThanOneThousand(value);
            return String.format(MERGE_PATTERN, this.oneThousand, super.asWords(remainder));
        }
        return super.asWords(value);
    }

    private boolean isBetweenOneThousandAndTwoThousand(Integer value) {
        return value >= 1000 && value < 2000;
    }

    private Integer getNumbersSmallerThanOneThousand(Integer values) {
        return values % 1000;
    }
}

