/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.czech;

import java.util.Map;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.NumberProcessor;

public class CzechIntegerToWordsConverter
implements IntegerToStringConverter {
    private final IntegerToStringConverter bigNumbersConverter;
    private final IntegerToStringConverter smallNumbersConverter;
    private final Map<Integer, String> exceptions;

    public CzechIntegerToWordsConverter(IntegerToStringConverter bigNumbersConverter, IntegerToStringConverter smallNumbersConverter, Map<Integer, String> exceptions) {
        this.bigNumbersConverter = bigNumbersConverter;
        this.smallNumbersConverter = smallNumbersConverter;
        this.exceptions = exceptions;
    }

    @Override
    public String asWords(Integer value) {
        if (this.exceptions.containsKey(value)) {
            return this.exceptions.get(value);
        }
        Integer bigNumber = value / 1000;
        Integer smallNumber = value % 1000;
        return new NumberProcessor(this.bigNumbersConverter, this.smallNumbersConverter).process(bigNumber, smallNumber);
    }
}

