/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.french;

import java.util.List;
import java.util.Map;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.converters.NumberToWordsConverter;
import pl.allegro.finance.tradukisto.internal.languages.PluralForms;
import pl.allegro.finance.tradukisto.internal.support.Range;

public class FrenchNumberToWordsConverter
extends NumberToWordsConverter {
    private final Map<Integer, String> exceptions;

    public FrenchNumberToWordsConverter(IntegerToStringConverter integerToStringConverter, Map<Integer, String> exceptions, List<PluralForms> pluralForms) {
        super(integerToStringConverter, pluralForms);
        this.exceptions = exceptions;
    }

    @Override
    public String asWords(Integer value) {
        if (this.exceptions.containsKey(value)) {
            return this.exceptions.get(value);
        }
        if (Range.closed(1000, 999999).contains(value)) {
            return this.thousandsAsString(value);
        }
        return super.asWords(value);
    }

    private String thousandsAsString(Integer value) {
        Integer thousands = value / 1000;
        Integer other = value % 1000;
        if (this.isOneThousand(thousands)) {
            return this.getOneThousandAsWords(other);
        }
        return this.getThousandsAsWords(thousands, other);
    }

    private String getThousandsAsWords(Integer thousands, Integer other) {
        if (this.nothingComesAfter(other)) {
            return String.format("%s mille", this.asWords(thousands));
        }
        return String.format("%s mille %s", this.asWords(thousands), this.asWords(other));
    }

    private String getOneThousandAsWords(Integer other) {
        return String.format("mille %s", this.asWords(other));
    }

    private boolean nothingComesAfter(Integer other) {
        return other == 0;
    }

    private boolean isOneThousand(Integer thousands) {
        return thousands == 1;
    }
}

