/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.turkish;

import java.math.BigDecimal;
import pl.allegro.finance.tradukisto.internal.BigDecimalToStringConverter;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.languages.turkish.TurkishValues;
import pl.allegro.finance.tradukisto.internal.support.Assert;

public class TurkishBigDecimalToBankingMoneyConverter
implements BigDecimalToStringConverter {
    private static final String SUBUNIT_SEPARATOR = ",";
    private static final String FORMAT = "%s%s%s%s";
    private static final int MAXIMAL_DECIMAL_PLACES_COUNT = 2;
    private final IntegerToStringConverter converter;
    private final TurkishValues turkishValues;

    public TurkishBigDecimalToBankingMoneyConverter(IntegerToStringConverter converter, TurkishValues turkishValues) {
        this.converter = converter;
        this.turkishValues = turkishValues;
    }

    @Override
    public String asWords(BigDecimal value) {
        return this.asWords(value, this.turkishValues.currency());
    }

    @Override
    public String asWords(BigDecimal value, String currencySymbol) {
        this.validate(value);
        Integer units = value.intValue();
        int subunits = value.remainder(BigDecimal.ONE).multiply(new BigDecimal(100)).intValue();
        String tempSubunitSymbol = this.turkishValues.subunitSymbol();
        String tempSubUnitWords = SUBUNIT_SEPARATOR + this.converter.asWords(subunits);
        if (subunits <= 0) {
            tempSubunitSymbol = "";
            tempSubUnitWords = "";
        }
        String formattedValue = String.format(FORMAT, this.converter.asWords(units), currencySymbol, tempSubUnitWords, tempSubunitSymbol);
        return formattedValue.replace(Character.toString(this.turkishValues.twoDigitsNumberSeparator()), "");
    }

    private void validate(BigDecimal value) {
        Assert.isTrue(value.scale() <= 2, () -> String.format("can't transform more than %s decimal places for value %s", 2, value));
        Assert.isTrue(this.valueLessThanIntMax(value), () -> String.format("can't transform numbers greater than Integer.MAX_VALUE for value %s", value));
        Assert.isTrue(this.valueGreaterThanOrEqualToZero(value), () -> String.format("can't transform negative numbers for value %s", value));
    }

    private boolean valueLessThanIntMax(BigDecimal value) {
        return value.compareTo(new BigDecimal(Integer.MAX_VALUE).add(BigDecimal.ONE)) < 0;
    }

    private boolean valueGreaterThanOrEqualToZero(BigDecimal value) {
        return value.signum() >= 0;
    }
}

