/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.ukrainian;

import pl.allegro.finance.tradukisto.internal.languages.GenderType;
import pl.allegro.finance.tradukisto.internal.languages.PluralForms;
import pl.allegro.finance.tradukisto.internal.support.Range;

public class UkrainianPluralForms
implements PluralForms {
    private final String singularForm;
    private final String pluralForm;
    private final String genitivePluralForm;
    private final GenderType genderType;

    public UkrainianPluralForms(String singularForm, String pluralForm, String genitivePluralForm, GenderType genderType) {
        this.singularForm = singularForm;
        this.pluralForm = pluralForm;
        this.genitivePluralForm = genitivePluralForm;
        this.genderType = genderType;
    }

    @Override
    public String formFor(Integer value) {
        if (this.useSingular(value)) {
            return this.singularForm;
        }
        if (this.usePluralForm(value)) {
            return this.pluralForm;
        }
        return this.genitivePluralForm;
    }

    private boolean useSingular(Integer value) {
        return value == 1 || value % 100 != 11 && value % 10 == 1;
    }

    private boolean usePluralForm(Integer value) {
        return Range.closed(2, 4).contains(value % 10) && !Range.closed(12, 14).contains(value % 100);
    }

    @Override
    public GenderType genderType() {
        return this.genderType;
    }
}

