/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto;

import java.math.BigDecimal;
import java.util.Objects;
import pl.allegro.finance.tradukisto.internal.BigDecimalToStringConverter;
import pl.allegro.finance.tradukisto.internal.Container;

public enum MoneyConverters {
    BRAZILIAN_PORTUGUESE_BANKING_MONEY_VALUE(Container.brazilianPortugueseContainer().getBankingMoneyConverter()),
    ENGLISH_BANKING_MONEY_VALUE(Container.englishContainer().getBankingMoneyConverter()),
    AMERICAN_ENGLISH_BANKING_MONEY_VALUE(Container.americanEnglishContainer().getBankingMoneyConverter()),
    GERMAN_BANKING_MONEY_VALUE(Container.germanContainer().getBankingMoneyConverter()),
    RUSSIAN_BANKING_MONEY_VALUE(Container.russianContainer().getBankingMoneyConverter()),
    POLISH_BANKING_MONEY_VALUE(Container.polishContainer().getBankingMoneyConverter()),
    ITALIAN_BANKING_MONEY_VALUE(Container.italianContainer().getBankingMoneyConverter()),
    CROATIAN_BANKING_MONEY_VALUE(Container.croatianContainer().getBankingMoneyConverter()),
    CZECH_BANKING_MONEY_VALUE(Container.czechContainer().getBankingMoneyConverter()),
    SLOVAK_BANKING_MONEY_VALUE(Container.slovakContainer().getBankingMoneyConverter()),
    LATVIAN_BANKING_MONEY_VALUE(Container.latvianContainer().getBankingMoneyConverter()),
    KAZAKH_BANKING_MONEY_VALUE(Container.kazakhContainer().getBankingMoneyConverter()),
    UKRAINIAN_BANKING_MONEY_VALUE(Container.ukrainianContainer().getBankingMoneyConverter()),
    TURKISH_BANKING_MONEY_VALUE(Container.turkishContainer().getBankingMoneyConverter()),
    SERBIAN_BANKING_MONEY_VALUE(Container.serbianContainer().getBankingMoneyConverter()),
    SERBIAN_CYRILLIC_BANKING_MONEY_VALUE(Container.serbianCyrillicContainer().getBankingMoneyConverter()),
    SLOVENE_BANKING_MONEY_VALUE(Container.sloveneContainer().getBankingMoneyConverter()),
    FRENCH_BANKING_MONEY_VALUE(Container.frenchContainer().getBankingMoneyConverter()),
    BULGARIAN_BANKING_MONEY_VALUE(Container.bulgarianContainer().getBankingMoneyConverter()),
    DUTCH_BANKING_MONEY_VALUE(Container.dutchContainer().getBankingMoneyConverter()),
    SPANISH_BANKING_MONEY_VALUE(Container.spanishContainer().getBankingMoneyConverter()),
    HINDI_BANKING_MONEY_VALUE(Container.hindiContainer().getBankingMoneyConverter()),
    SWEDISH_BANKING_MONEY_VALUE(Container.swedishContainer().getBankingMoneyConverter()),
    JAPANESE_BANKING_MONEY_VALUE(Container.japaneseKanjiContainer().getBankingMoneyConverter());

    private final BigDecimalToStringConverter converter;

    private MoneyConverters(BigDecimalToStringConverter converter) {
        this.converter = converter;
    }

    public String asWords(BigDecimal value) {
        Objects.requireNonNull(value);
        return this.converter.asWords(value);
    }

    public String asWords(BigDecimal value, String currencySymbol) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(currencySymbol);
        return this.converter.asWords(value, currencySymbol);
    }
}

