/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.japanese;

import java.util.List;
import pl.allegro.finance.tradukisto.internal.converters.NumberToWordsConverter;
import pl.allegro.finance.tradukisto.internal.languages.PluralForms;
import pl.allegro.finance.tradukisto.internal.languages.japanese.JapaneseThousandToWordsConverter;
import pl.allegro.finance.tradukisto.internal.support.Assert;
import pl.allegro.finance.tradukisto.internal.support.JapaneseNumberChunking;
import pl.allegro.finance.tradukisto.internal.support.NumberChunking;

public class JapaneseNumberToWordsConverter
extends NumberToWordsConverter {
    private final NumberChunking numberChunking = new JapaneseNumberChunking();
    private final List<PluralForms> pluralForms;

    public JapaneseNumberToWordsConverter(JapaneseThousandToWordsConverter japaneseThousandToWordsConverter, List<PluralForms> pluralForms) {
        super(japaneseThousandToWordsConverter, pluralForms);
        this.pluralForms = pluralForms;
    }

    @Override
    public String asWords(Long value) {
        Assert.isTrue(value >= 0L, () -> String.format("can't convert negative numbers for value %d", value));
        List<Integer> valueChunks = this.numberChunking.chunk(value);
        List<PluralForms> formsToUse = this.getRequiredFormsInReversedOrder(valueChunks.size());
        return this.joinValueChunksWithForms(valueChunks.iterator(), formsToUse.iterator());
    }

    @Override
    protected String joinParts(List<String> result) {
        return result.isEmpty() ? this.hundredsToWordsConverter.asWords(0, this.pluralForms.get(0).genderType()) : String.join((CharSequence)"", result).trim();
    }
}

