/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.spanish;

import java.util.Map;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.MultiFormNumber;
import pl.allegro.finance.tradukisto.internal.languages.GenderForms;
import pl.allegro.finance.tradukisto.internal.languages.GenderType;
import pl.allegro.finance.tradukisto.internal.support.Range;

public class SpanishThousandToWordsConverter
implements IntegerToStringConverter {
    private static final String MIL = "%s mil";
    private static final String MIL_UN = "mil %s";
    private static final String S_MIL_S = "%s mil %s";
    private static final String IUN_MIL = "%si\u00fan mil";
    private static final String IUN_MIL_WITH_HUNDRED = "%si\u00fan mil %s";
    private static final String Y_UN_MIL = "%s y un mil";
    private static final String Y_UN_MIL_WITH_HUNDRED = "%s y un mil %s";
    private static final boolean HAS_NEXT_VALUE = true;
    private static final boolean HAS_NOT_NEXT_VALUE = false;
    private static final int HUNDRED = 100;
    private static final GenderType genderType = GenderType.NEUTER;
    private final Map<Integer, GenderForms> baseValues;
    private final Map<Integer, MultiFormNumber> exceptions;

    public SpanishThousandToWordsConverter(Map<Integer, GenderForms> baseValues, Map<Integer, MultiFormNumber> exceptions) {
        this.baseValues = baseValues;
        this.exceptions = exceptions;
    }

    @Override
    public String asWords(Integer value) {
        return this.asWords(value, true);
    }

    private String asWords(Integer value, boolean hasNextNumber) {
        if (this.baseValues.containsKey(value)) {
            return this.baseValues.get(value).formFor(genderType);
        }
        if (this.exceptions.containsKey(value)) {
            if (hasNextNumber) {
                return this.exceptions.get(value).getRegularForm();
            }
            return this.exceptions.get(value).getAloneForm();
        }
        if (Range.closed(31, 99).contains(value)) {
            return this.twoDigitsNumberAsString(value);
        }
        if (Range.closed(101, 999).contains(value)) {
            return this.threeDigitsNumberAsString(value);
        }
        if (Range.closed(1000, 999999).contains(value)) {
            return this.thousandsAsString(value);
        }
        throw new IllegalArgumentException(String.format("Can't convert %d", value));
    }

    private String twoDigitsNumberAsString(Integer value) {
        Integer units = value % 10;
        Integer tens = value - units;
        return String.format("%s y %s", this.asWords(tens), this.asWords(units));
    }

    private String threeDigitsNumberAsString(Integer value) {
        Integer tensWithUnits = value % 100;
        Integer hundreds = value - tensWithUnits;
        boolean hasNextNumber = tensWithUnits != 0;
        return String.format("%s %s", this.asWords(hundreds, hasNextNumber), this.asWords(tensWithUnits));
    }

    private String thousandsAsString(Integer value) {
        Integer thousands = value / 1000;
        Integer other = value % 1000;
        if (this.isOneThousand(thousands)) {
            return this.getOneThousandAsWords(other);
        }
        if (this.isEndsWithOne(thousands)) {
            return this.getEndWithOneAsWords(thousands, other);
        }
        return this.getThousandsAsWords(thousands, other);
    }

    private String getThousandsAsWords(Integer thousands, Integer other) {
        if (this.nothingComesAfter(other)) {
            return String.format(MIL, this.asWords(thousands));
        }
        if (other == 100) {
            return String.format(S_MIL_S, this.asWords(thousands, false), this.asWords(other, false));
        }
        return String.format(S_MIL_S, this.asWords(thousands), this.asWords(other, true));
    }

    private String getOneThousandAsWords(Integer other) {
        if (this.nothingComesAfter(other)) {
            return "mil";
        }
        if (other == 100) {
            return String.format(MIL_UN, this.asWords(other, false));
        }
        return String.format(MIL_UN, this.asWords(other, true));
    }

    private String getEndWithOneAsWords(Integer thousands, Integer other) {
        Integer units = thousands % 10;
        Integer tens = thousands - units;
        if (thousands == 21) {
            if (this.nothingComesAfter(other)) {
                return String.format(IUN_MIL, this.asWords(tens).substring(0, 5));
            }
            if (other == 100) {
                return String.format(IUN_MIL_WITH_HUNDRED, this.asWords(tens, false).substring(0, 5), this.asWords(other, false));
            }
            return String.format(IUN_MIL_WITH_HUNDRED, this.asWords(tens).substring(0, 5), this.asWords(other, true));
        }
        if (this.nothingComesAfter(other)) {
            return String.format(Y_UN_MIL, this.asWords(tens));
        }
        if (other == 100) {
            return String.format(Y_UN_MIL_WITH_HUNDRED, this.asWords(tens, false), this.asWords(other, false));
        }
        return String.format(Y_UN_MIL_WITH_HUNDRED, this.asWords(tens), this.asWords(other, true));
    }

    private boolean nothingComesAfter(Integer other) {
        return other == 0;
    }

    private boolean isOneThousand(Integer thousands) {
        return thousands == 1;
    }

    private boolean isEndsWithOne(Integer number) {
        if (number > 20 && number < 100) {
            return Math.abs(number) % 10 == 1;
        }
        return false;
    }
}

