/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.turkish;

import pl.allegro.finance.tradukisto.internal.GenderAwareIntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.languages.GenderType;
import pl.allegro.finance.tradukisto.internal.languages.turkish.TurkishValues;
import pl.allegro.finance.tradukisto.internal.support.Range;

public class TurkishSmallNumbersToWordsConverter
implements GenderAwareIntegerToStringConverter {
    private final TurkishValues turkishValues;
    private final char separator;

    public TurkishSmallNumbersToWordsConverter(TurkishValues turkishValues) {
        this.turkishValues = turkishValues;
        this.separator = turkishValues.twoDigitsNumberSeparator();
    }

    @Override
    public String asWords(Integer value, GenderType genderType) {
        if (this.turkishValues.baseNumbers().containsKey(value)) {
            return this.turkishValues.baseNumbers().get(value).formFor(genderType);
        }
        if (Range.closed(21, 99).contains(value)) {
            return this.twoDigitsNumberAsString(value, genderType);
        }
        if (Range.closed(101, 999).contains(value)) {
            return this.threeDigitsNumberAsString(value, genderType);
        }
        if (value == 1000) {
            return "Bin";
        }
        if (Range.closed(1001, 1999).contains(value)) {
            return this.oneThousandsAsString(value, genderType);
        }
        if (Range.closed(2000, 999999).contains(value)) {
            return this.greaterThanOneThousandsAsString(value, genderType);
        }
        throw new IllegalArgumentException(String.format("Can't convert %d", value));
    }

    private String twoDigitsNumberAsString(Integer value, GenderType genderType) {
        Integer units = value % 10;
        Integer tens = value - units;
        return String.format("%s" + this.separator + "%s", this.asWords(tens, genderType), this.asWords(units, genderType));
    }

    private String threeDigitsNumberAsString(Integer value, GenderType genderType) {
        Integer tensWithUnits = value % 100;
        Integer hundreds = value - tensWithUnits;
        return String.format("%s" + this.separator + "%s", this.asWords(hundreds, genderType), this.asWords(tensWithUnits, genderType));
    }

    private String greaterThanOneThousandsAsString(Integer value, GenderType genderType) {
        Integer thousands = value / 1000;
        Integer other = value % 1000;
        if (other == 0) {
            return String.format("%s" + this.separator + "Bin", this.asWords(thousands, genderType));
        }
        return String.format("%s" + this.separator + "Bin" + this.separator + "%s", this.asWords(thousands, genderType), this.asWords(other, genderType));
    }

    private String oneThousandsAsString(Integer value, GenderType genderType) {
        Integer other = value % 1000;
        return String.format("Bin" + this.separator + "%s", this.asWords(other, genderType));
    }
}

