/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.support;

import java.util.LinkedList;
import java.util.List;
import pl.allegro.finance.tradukisto.internal.support.NumberChunking;

public class IndianNumberChunking
extends NumberChunking {
    private static final int INDIAN_SPLIT_FACTOR = 100;

    @Override
    public List<Integer> chunk(Long value) {
        int splitCounter = 0;
        LinkedList<Integer> result = new LinkedList<Integer>();
        while (value > 0L) {
            if (splitCounter < 1) {
                result.addFirst((int)(value % 1000L));
                value = value / 1000L;
                ++splitCounter;
                continue;
            }
            result.addFirst((int)(value % 100L));
            value = value / 100L;
            ++splitCounter;
        }
        return result;
    }
}

