/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tdr.gruntmaven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import pl.allegro.tdr.gruntmaven.BaseMavenGruntMojo;
import pl.allegro.tdr.gruntmaven.executable.Executable;

public abstract class AbstractExecutableMojo
extends BaseMavenGruntMojo {
    private static final String WINDOWS_OS_FAMILY = "Windows";
    private static final String EXEC_MAVEN_GROUP = "org.codehaus.mojo";
    private static final String EXEC_MAVEN_ARTIFACT = "exec-maven-plugin";
    private static final String EXEC_GOAL = "exec";
    private static final String EXEC_SUCCESS_CODES_ELEMENT = "successCodes";
    private static final String EXEC_SUCCESS_CODE_ELEMENT = "successCode";
    @Parameter(defaultValue="${os.name}")
    private String osName;
    @Parameter(property="showColors", defaultValue="false")
    protected boolean showColors;
    @Parameter(property="execMavenPluginVersion", defaultValue="1.2.1")
    protected String execMavenPluginVersion;

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        for (Executable executable : this.getExecutables()) {
            this.runExecutable(executable);
        }
    }

    private void runExecutable(Executable executable) throws MojoExecutionException, MojoFailureException {
        MojoExecutor.Element[] configuration = this.buildConfigForOS(executable);
        if (executable.overrideSuccessCodes()) {
            MojoExecutor.Element customSuccessCodes = this.overwriteSuccessCodes(executable);
            configuration = this.concat(configuration, customSuccessCodes);
        }
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)EXEC_MAVEN_GROUP), (String)MojoExecutor.artifactId((String)EXEC_MAVEN_ARTIFACT), (String)MojoExecutor.version((String)this.execMavenPluginVersion)), (String)MojoExecutor.goal((String)EXEC_GOAL), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])configuration), (MojoExecutor.ExecutionEnvironment)this.pluginExecutionEvnironment());
    }

    private MojoExecutor.Element[] buildConfigForOS(Executable executable) {
        this.getLog().info((CharSequence)("OS Name: " + this.osName));
        MojoExecutor.Element[] configuration = this.osName.toUpperCase().contains(WINDOWS_OS_FAMILY.toUpperCase()) ? this.buildConfigForWindows(executable) : this.buildConfigForProperOS(executable);
        configuration = this.concat(configuration, MojoExecutor.element((String)MojoExecutor.name((String)"workingDirectory"), (String)this.gruntBuildDirectory));
        if (executable.hasEnvironmentVars()) {
            configuration = this.concat(configuration, MojoExecutor.element((String)"environmentVariables", (MojoExecutor.Element[])this.elementsFromMap(executable.environmentVars())));
        }
        return configuration;
    }

    private MojoExecutor.Element[] buildConfigForProperOS(Executable executable) {
        MojoExecutor.Element[] osConfiguration = new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"executable"), (String)executable.executableName()), MojoExecutor.element((String)MojoExecutor.name((String)"arguments"), (MojoExecutor.Element[])executable.argumentsArray())};
        return osConfiguration;
    }

    private MojoExecutor.Element[] buildConfigForWindows(Executable executable) {
        MojoExecutor.Element[] arguments = new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)"/C"), MojoExecutor.element((String)MojoExecutor.name((String)"argument"), (String)executable.executableName())};
        arguments = this.concat(arguments, executable.argumentsArray());
        MojoExecutor.Element[] osConfiguration = new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"executable"), (String)"cmd"), MojoExecutor.element((String)MojoExecutor.name((String)"arguments"), (MojoExecutor.Element[])arguments)};
        return osConfiguration;
    }

    protected <T> T[] concat(T[] array1, T ... array2) {
        T[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    private MojoExecutor.Element[] elementsFromMap(Map<String, String> elements) {
        ArrayList<MojoExecutor.Element> elementList = new ArrayList<MojoExecutor.Element>();
        for (Map.Entry<String, String> entry : elements.entrySet()) {
            elementList.add(MojoExecutor.element((String)entry.getKey(), (String)entry.getValue()));
        }
        return elementList.toArray(new MojoExecutor.Element[elementList.size()]);
    }

    protected abstract List<Executable> getExecutables();

    private MojoExecutor.Element overwriteSuccessCodes(Executable executable) {
        MojoExecutor.Element[] successCodesElements = new MojoExecutor.Element[executable.successCodes().length];
        for (int index = 0; index < executable.successCodes().length; ++index) {
            successCodesElements[index] = MojoExecutor.element((String)EXEC_SUCCESS_CODE_ELEMENT, (String)executable.successCodes()[index]);
        }
        return MojoExecutor.element((String)EXEC_SUCCESS_CODES_ELEMENT, (MojoExecutor.Element[])successCodesElements);
    }
}

