/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tdr.gruntmaven;

import java.io.File;
import java.io.IOException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class BaseMavenGruntMojo
extends AbstractMojo {
    @Parameter(property="gruntBuildDirectory", defaultValue="${basedir}/target-grunt")
    protected String gruntBuildDirectory;
    @Parameter(property="sourceDirectory", defaultValue="src/main/webapp")
    protected String sourceDirectory;
    @Parameter(property="jsSourceDirectory", defaultValue="static")
    protected String jsSourceDirectory;
    @Parameter(property="npmOfflineModulesFile", defaultValue="node_modules.tar")
    protected String npmOfflineModulesFile;
    @Parameter(property="disabled", defaultValue="false")
    private boolean disabled;
    @Parameter(property="npmOfflineModulesFilePath", defaultValue="")
    protected String npmOfflineModulesFilePath;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession mavenSession;
    @Component
    private PluginManager pluginManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.disabled) {
            this.executeInternal();
        } else {
            this.getLog().info((CharSequence)"Execution disabled using configuration option.");
        }
    }

    protected abstract void executeInternal() throws MojoExecutionException, MojoFailureException;

    protected String basedir() {
        try {
            return this.mavenProject.getBasedir().getCanonicalPath();
        }
        catch (IOException exception) {
            throw new IllegalStateException("Could not extract basedir of project.", exception);
        }
    }

    protected String target() {
        return this.mavenProject.getBuild().getDirectory();
    }

    protected String fullJsSourceDirectory() {
        return this.basedir() + File.separator + this.sourceDirectory + File.separator + this.jsSourceDirectory;
    }

    protected String relativeJsSourceDirectory() {
        return this.sourceDirectory + File.separator + this.jsSourceDirectory;
    }

    protected MojoExecutor.ExecutionEnvironment pluginExecutionEvnironment() {
        MojoExecutor.ExecutionEnvironment environment;
        try {
            Object o = this.mavenSession.lookup("org.apache.maven.plugin.BuildPluginManager");
            environment = MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)((BuildPluginManager)o));
        }
        catch (ComponentLookupException e) {
            environment = MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (PluginManager)this.pluginManager);
        }
        return environment;
    }
}

