/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tdr.gruntmaven;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import pl.allegro.tdr.gruntmaven.BaseMavenGruntMojo;
import pl.allegro.tdr.gruntmaven.resources.Resource;

@Mojo(name="create-resources", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class CreateResourcesMojo
extends BaseMavenGruntMojo {
    private static final String INNER_PROPERTIES_RESOURCE_NAME = "grunt-maven.json";
    private static final int FILTERED_RESOURCES_JSON_LENGTH = 100;
    private static final String RESOURCES_MAVEN_GROUP = "org.apache.maven.plugins";
    private static final String RESOURCES_MAVEN_ARTIFACT = "maven-resources-plugin";
    private static final String RESOURCES_GOAL = "copy-resources";
    @Parameter(property="mavenResourcesPluginVersion", defaultValue="2.6")
    private String mavenResourcesPluginVersion;
    @Parameter(property="overwriteResources", defaultValue="true")
    private boolean overwriteResources;
    @Parameter(property="filteredResources")
    private String[] filteredResources;
    @Parameter(property="excludedResources")
    private String[] excludedResources;

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)RESOURCES_MAVEN_GROUP), (String)MojoExecutor.artifactId((String)RESOURCES_MAVEN_ARTIFACT), (String)MojoExecutor.version((String)this.mavenResourcesPluginVersion)), (String)MojoExecutor.goal((String)RESOURCES_GOAL), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"overwrite"), (String)Boolean.toString(this.overwriteResources)), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)this.gruntBuildDirectory), MojoExecutor.element((String)MojoExecutor.name((String)"resources"), (MojoExecutor.Element[])this.createResourceElements())}), (MojoExecutor.ExecutionEnvironment)this.pluginExecutionEvnironment());
        this.createWorkflowTasksDirectory();
        this.createInnerPropertiesResource();
    }

    private MojoExecutor.Element[] createResourceElements() {
        ArrayList<MojoExecutor.Element> resourceElements = new ArrayList<MojoExecutor.Element>(2);
        MojoExecutor.Element normalResourcesElement = MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)(this.sourceDirectory + "/" + this.jsSourceDirectory)), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"**/*")}), MojoExecutor.element((String)MojoExecutor.name((String)"excludes"), (MojoExecutor.Element[])this.createResourcesListElement(this.excludedResources, "exclude", MojoExecutor.element((String)MojoExecutor.name((String)"exclude"), (String)("**/" + this.npmOfflineModulesFile)))), MojoExecutor.element((String)MojoExecutor.name((String)"filtering"), (String)"false")});
        resourceElements.add(normalResourcesElement);
        if (this.filteredResources.length > 0) {
            MojoExecutor.Element filteredResourcesElement = MojoExecutor.element((String)MojoExecutor.name((String)"resource"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"directory"), (String)(this.sourceDirectory + "/" + this.jsSourceDirectory)), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])this.createResourcesListElement(this.filteredResources, "include", new MojoExecutor.Element[0])), MojoExecutor.element((String)MojoExecutor.name((String)"filtering"), (String)"true")});
            resourceElements.add(filteredResourcesElement);
        }
        return resourceElements.toArray(new MojoExecutor.Element[resourceElements.size()]);
    }

    private void createWorkflowTasksDirectory() {
        File file = new File(this.pathToWorkflowTasksDirectory());
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private MojoExecutor.Element[] createResourcesListElement(String[] resources, String elementName, MojoExecutor.Element ... append) {
        int index;
        MojoExecutor.Element[] elements = new MojoExecutor.Element[resources.length + append.length];
        for (index = 0; index < resources.length; ++index) {
            elements[index] = MojoExecutor.element((String)MojoExecutor.name((String)elementName), (String)resources[index]);
        }
        int appendIndex = 0;
        while (appendIndex < append.length) {
            elements[index] = append[appendIndex];
            ++appendIndex;
            ++index;
        }
        return elements;
    }

    private void createInnerPropertiesResource() {
        Resource.from("/grunt-maven.json", this.getLog()).withFilter("filesToWatch", this.pathToWatchDirectory() + File.separator + "**").withFilter("directoryToWatch", this.pathToWatchDirectory()).withFilter("projectRootPath", this.basedir()).withFilter("targetPath", this.target()).withFilter("sourceDirectory", this.sourceDirectory).withFilter("jsSourceDirectory", this.jsSourceDirectory).withFilter("filteredFiles", this.filteredResourcesAsJSONArray()).copyAndOverwrite(this.pathToWorkflowTasksDirectory() + INNER_PROPERTIES_RESOURCE_NAME);
    }

    private String filteredResourcesAsJSONArray() {
        int index;
        StringBuilder builder = new StringBuilder(100);
        builder.append("[");
        builder.append("\"").append("**/").append(this.npmOfflineModulesFile).append("\"").append(", ");
        for (index = 0; index < this.filteredResources.length; ++index) {
            builder.append("\"").append(this.filteredResources[index]).append("\"").append(", ");
        }
        for (index = 0; index < this.excludedResources.length; ++index) {
            builder.append("\"").append(this.excludedResources[index]).append("\"").append(", ");
        }
        builder.delete(builder.length() - 2, builder.length());
        builder.append("]");
        return builder.toString();
    }

    private String pathToWatchDirectory() {
        return this.fullJsSourceDirectory();
    }

    private String pathToWorkflowTasksDirectory() {
        return this.pathToGruntBuildDirectory() + File.separator;
    }

    private String pathToGruntBuildDirectory() {
        return this.gruntBuildDirectory + File.separator;
    }
}

