/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tdr.gruntmaven;

import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import pl.allegro.tdr.gruntmaven.AbstractExecutableMojo;
import pl.allegro.tdr.gruntmaven.executable.Executable;

@Mojo(name="grunt", defaultPhase=LifecyclePhase.COMPILE)
public class ExecGruntMojo
extends AbstractExecutableMojo {
    private static final String[] IGNORE_GRUNT_TASKS_ERRORS_CUSTOM_CODES = new String[]{"0", "3", "6"};
    private static final String[] IGNORE_ALL_GRUNT_ERRORS_CUSTOM_CODES = new String[]{"0", "1", "2", "3", "4", "5", "6"};
    @Parameter(property="target", defaultValue="")
    private String target;
    @Parameter(property="nodeExecutable", defaultValue="node")
    private String nodeExecutable;
    @Parameter(property="gruntExecutable", defaultValue="grunt")
    private String gruntExecutable;
    @Parameter(property="runGruntWithNode", defaultValue="false")
    private boolean runGruntWithNode;
    @Parameter(property="gruntOptions")
    private String[] gruntOptions;
    @Parameter(property="ignoreTasksErrors", defaultValue="false")
    private boolean ignoreTasksErrors;
    @Parameter(property="ignoreAllErrors", defaultValue="false")
    private boolean ignoreAllErrors;

    @Override
    protected List<Executable> getExecutables() {
        Executable executable = this.runGruntWithNode ? new Executable(this.nodeExecutable, this.customSuccessCodes()) : new Executable(this.gruntExecutable, this.customSuccessCodes());
        this.appendArguments(executable);
        return Arrays.asList(executable);
    }

    private void appendArguments(Executable executable) {
        if (this.runGruntWithNode) {
            executable.addArgument(this.gruntExecutable);
        }
        if (this.target != null && !this.target.isEmpty()) {
            executable.addArgument(this.target);
        }
        if (!this.showColors) {
            executable.addArgument("--no-color");
        }
        if (this.gruntOptions != null) {
            for (String option : this.gruntOptions) {
                executable.addNormalizedArgument(option, "=");
            }
        }
    }

    private String[] customSuccessCodes() {
        if (this.ignoreAllErrors) {
            return IGNORE_ALL_GRUNT_ERRORS_CUSTOM_CODES;
        }
        if (this.ignoreTasksErrors) {
            return IGNORE_GRUNT_TASKS_ERRORS_CUSTOM_CODES;
        }
        return null;
    }
}

