/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tdr.gruntmaven;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import pl.allegro.tdr.gruntmaven.AbstractExecutableMojo;
import pl.allegro.tdr.gruntmaven.executable.Executable;

@Mojo(name="npm", defaultPhase=LifecyclePhase.COMPILE)
public class ExecNpmMojo
extends AbstractExecutableMojo {
    protected static final String NPM_INSTALL_COMMAND = "install";
    @Parameter(property="npmExecutable", defaultValue="npm")
    protected String npmExecutable;
    @Parameter(property="npmOptions")
    private String[] npmOptions;
    @Parameter
    protected Map<String, String> npmEnvironmentVar;

    @Override
    protected List<Executable> getExecutables() {
        Executable executable = new Executable(this.npmExecutable);
        executable.addEnvironmentVars(this.npmEnvironmentVar);
        executable.addArgument(NPM_INSTALL_COMMAND);
        this.appendNoColorsArgument(executable);
        this.appendNpmOptions(executable);
        return Arrays.asList(executable);
    }

    protected void appendNpmOptions(Executable executable) {
        executable.addNormalizedArguments(this.npmOptions, "=");
    }

    protected void appendNoColorsArgument(Executable executable) {
        if (!this.showColors) {
            executable.addArgument("--color=false");
        }
    }
}

