/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tdr.gruntmaven;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import pl.allegro.tdr.gruntmaven.ExecNpmMojo;
import pl.allegro.tdr.gruntmaven.archive.TarUtil;
import pl.allegro.tdr.gruntmaven.executable.Executable;

@Mojo(name="npm-offline", defaultPhase=LifecyclePhase.COMPILE)
public class ExecNpmOfflineMojo
extends ExecNpmMojo {
    private static final String NODE_MODULES_DIR_NAME = "node_modules";
    private static final String NPM_REBUILD_COMMAND = "rebuild";
    @Parameter(property="npmRebuildOptions")
    private String[] npmRebuildOptions;

    @Override
    protected List<Executable> getExecutables() {
        this.unpackModules();
        return Arrays.asList(this.createNpmInstallExecutable(), this.createNpmRebuildExecutable());
    }

    private void unpackModules() {
        String nodeModulesPath = this.gruntBuildDirectory + File.separator + NODE_MODULES_DIR_NAME;
        File targetModulesPath = new File(nodeModulesPath);
        if (targetModulesPath.exists()) {
            this.getLog().info((CharSequence)("Found existing node_modules at " + nodeModulesPath + " , not going to overwrite them."));
            return;
        }
        if (this.npmOfflineModulesFilePath == null) {
            this.npmOfflineModulesFilePath = this.relativeJsSourceDirectory();
        }
        File offlineModules = new File(this.basedir() + File.separator + this.npmOfflineModulesFilePath + File.separator + this.npmOfflineModulesFile);
        File targetPath = new File(this.gruntBuildDirectory);
        TarUtil.untar(offlineModules, targetPath, this.getLog());
    }

    private Executable createNpmInstallExecutable() {
        Executable executable = new Executable(this.npmExecutable);
        executable.addArgument("install");
        executable.addArgument("--ignore-scripts");
        this.appendNoColorsArgument(executable);
        this.appendNpmOptions(executable);
        executable.addEnvironmentVars(this.npmEnvironmentVar);
        return executable;
    }

    private Executable createNpmRebuildExecutable() {
        Executable executable = new Executable(this.npmExecutable);
        executable.addArgument(NPM_REBUILD_COMMAND);
        this.appendNoColorsArgument(executable);
        executable.addNormalizedArguments(this.npmRebuildOptions, "=");
        return executable;
    }
}

