/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tdr.gruntmaven.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.archiver.tar.TarEntry;
import org.codehaus.plexus.archiver.tar.TarInputStream;
import org.codehaus.plexus.util.IOUtil;

public final class TarUtil {
    private TarUtil() {
    }

    public static void untar(File source, File target, Log logger) {
        TarInputStream tarInput = null;
        FileOutputStream output = null;
        try {
            tarInput = new TarInputStream((InputStream)new FileInputStream(source));
            TarEntry entry = tarInput.getNextEntry();
            while (entry != null) {
                File outputFile = new File(target.getCanonicalPath() + File.separator + entry.getName());
                if (entry.isDirectory()) {
                    logger.debug((CharSequence)("creating dir at: " + outputFile.getCanonicalPath()));
                    outputFile.mkdirs();
                } else {
                    logger.debug((CharSequence)("creating file at: " + outputFile.getCanonicalPath()));
                    output = new FileOutputStream(outputFile);
                    IOUtil.copy((InputStream)tarInput, (OutputStream)output);
                    output.flush();
                    ((OutputStream)output).close();
                }
                entry = tarInput.getNextEntry();
            }
        }
        catch (IOException exception) {
            try {
                throw new IllegalStateException(exception);
            }
            catch (Throwable throwable) {
                IOUtil.close(tarInput);
                IOUtil.close(output);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)tarInput);
        IOUtil.close(output);
    }
}

