/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tdr.gruntmaven.resources;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;
import pl.allegro.tdr.gruntmaven.resources.Filter;
import pl.allegro.tdr.gruntmaven.resources.ResourceCreationException;

public class Resource {
    private final String resourceName;
    private final Set<Filter> filters = new HashSet<Filter>();
    private final Log logger;

    public static Resource from(String resourceName, Log logger) {
        return new Resource(resourceName, logger);
    }

    public Resource(String resourceName, Log logger) {
        this.resourceName = resourceName;
        this.logger = logger;
    }

    public Resource withFilter(String placeholder, String value) {
        this.filters.add(new Filter(placeholder, value));
        return this;
    }

    public void copy(String to) {
        this.copyResource(to, false);
    }

    public void copyAndOverwrite(String to) {
        this.copyResource(to, true);
    }

    private void copyResource(String targetPath, boolean overwrite) {
        try {
            String contents = this.filter(this.read());
            File targetFile = new File(targetPath);
            if (!targetFile.exists() || overwrite) {
                FileUtils.copyStreamToFile((InputStreamFacade)this.contentAsInputStream(contents), (File)targetFile);
            } else {
                this.logger.debug((CharSequence)("Not overwriting file " + targetPath));
            }
        }
        catch (IOException exception) {
            throw new ResourceCreationException(this.resourceName, targetPath, exception);
        }
    }

    private InputStreamFacade contentAsInputStream(String content) {
        return new RawInputStreamFacade((InputStream)new ByteArrayInputStream(content.getBytes()));
    }

    private String read() throws IOException {
        InputStream stream = Resource.class.getResourceAsStream(this.resourceName);
        StringWriter contentsWriter = new StringWriter();
        IOUtil.copy((InputStream)stream, (Writer)contentsWriter);
        return contentsWriter.toString();
    }

    private String filter(String contents) {
        String filteredContents = contents;
        for (Filter filter : this.filters) {
            filteredContents = filter.filter(filteredContents);
        }
        return filteredContents;
    }
}

