/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tdr.gruntmaven;

import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import pl.allegro.tdr.gruntmaven.AbstractExecutableMojo;
import pl.allegro.tdr.gruntmaven.executable.Executable;

@Mojo(name="bower", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class ExecBowerMojo
extends AbstractExecutableMojo {
    private static final String BOWER_INSTALL_COMMAND = "install";
    @Parameter(property="bowerExecutable", defaultValue="bower")
    private String bowerExecutable;
    @Parameter(property="bowerOptions")
    private String[] bowerOptions;

    @Override
    protected List<Executable> getExecutables() {
        Executable executable = new Executable(this.bowerExecutable);
        executable.addArgument(BOWER_INSTALL_COMMAND);
        if (!this.showColors) {
            executable.addArgument("--color=false");
        }
        for (String opt : this.bowerOptions) {
            executable.addNormalizedArgument(opt, "=");
        }
        return Arrays.asList(executable);
    }
}

