/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tdr.gruntmaven.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;

public final class TarUtil {
    private TarUtil() {
    }

    public static void untar(File source, File target, Log logger) {
        TarArchiveInputStream tarInput = null;
        FileOutputStream output = null;
        try {
            tarInput = new TarArchiveInputStream((InputStream)new FileInputStream(source));
            ArchiveEntry entry = tarInput.getNextEntry();
            while (entry != null) {
                File outputFile = new File(target.getCanonicalPath() + File.separator + entry.getName());
                if (entry.isDirectory()) {
                    logger.debug((CharSequence)("creating dir at: " + outputFile.getCanonicalPath()));
                    outputFile.mkdirs();
                } else {
                    logger.debug((CharSequence)("creating file at: " + outputFile.getCanonicalPath()));
                    output = new FileOutputStream(outputFile);
                    IOUtils.copy((InputStream)tarInput, (OutputStream)output);
                    output.flush();
                    ((OutputStream)output).close();
                }
                entry = tarInput.getNextEntry();
            }
        }
        catch (IOException exception) {
            try {
                throw new IllegalStateException(exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(tarInput);
                IOUtils.closeQuietly(output);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)tarInput);
        IOUtils.closeQuietly(output);
    }
}

