/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tdr.gruntmaven.executable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class Executable {
    private static final Pattern WHITESPACED_OPTION_PATTERN = Pattern.compile("^-{1,2}?[\\w-]*\\s+");
    private static final String ARGUMENT_NAME = "argument";
    private final String executableName;
    private List<MojoExecutor.Element> arguments = new ArrayList<MojoExecutor.Element>();
    private final String[] successCodes;
    private Map<String, String> environmentVars = new HashMap<String, String>();

    public Executable(String executableName, String[] successCodes) {
        this.executableName = executableName;
        this.successCodes = successCodes;
    }

    public Executable(String executableName) {
        this(executableName, null);
    }

    Executable(Executable executable) {
        this.executableName = executable.executableName();
        this.arguments = new ArrayList<MojoExecutor.Element>(executable.arguments());
        this.successCodes = executable.successCodes();
    }

    public void addArgument(String value) {
        this.arguments.add(MojoExecutor.element((String)MojoExecutor.name((String)ARGUMENT_NAME), (String)value));
    }

    public void addNormalizedArgument(String value, String whitespaceReplacement) {
        this.arguments.add(MojoExecutor.element((String)MojoExecutor.name((String)ARGUMENT_NAME), (String)this.normalizeArgument(value, whitespaceReplacement)));
    }

    public void addNormalizedArguments(String[] values, String whitespaceReplacement) {
        if (values != null) {
            for (String value : values) {
                this.addNormalizedArgument(value, whitespaceReplacement);
            }
        }
    }

    public boolean hasEnvironmentVars() {
        return !this.environmentVars.isEmpty();
    }

    public Map<String, String> environmentVars() {
        return Collections.unmodifiableMap(this.environmentVars);
    }

    public void addEnvironmentVars(Map<String, String> environmentVars) {
        if (environmentVars != null) {
            this.environmentVars.putAll(environmentVars);
        }
    }

    private String normalizeArgument(String argument, String whitespaceReplacement) {
        Matcher matcher = WHITESPACED_OPTION_PATTERN.matcher(argument);
        if (matcher.find()) {
            return argument.replaceFirst("\\s+", whitespaceReplacement);
        }
        return argument;
    }

    public String executableName() {
        return this.executableName;
    }

    public List<MojoExecutor.Element> arguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public MojoExecutor.Element[] argumentsArray() {
        return this.arguments.toArray(new MojoExecutor.Element[this.arguments.size()]);
    }

    public boolean overrideSuccessCodes() {
        return this.successCodes != null;
    }

    public String[] successCodes() {
        return this.successCodes;
    }
}

