/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.boot.autoconfigure.handlebars;

import com.github.jknack.handlebars.cache.GuavaTemplateCache;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.springmvc.HandlebarsViewResolver;
import com.google.common.cache.CacheBuilder;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.allegro.tech.boot.autoconfigure.handlebars.HandlebarsProperties;

@ConditionalOnProperty(prefix="handlebars", value={"enabled"}, havingValue="true", matchIfMissing=true)
@Configuration
@EnableConfigurationProperties(value={HandlebarsProperties.class})
@ConditionalOnWebApplication
public class HandlebarsAutoConfiguration {

    @Configuration
    @ConditionalOnProperty(value={"handlebars.infiniteLoops"})
    protected static class InfiniteLoopsConfiguration {
        @Autowired
        private HandlebarsViewResolver handlebarsViewResolver;

        protected InfiniteLoopsConfiguration() {
        }

        @PostConstruct
        public void setInfiniteLoops() {
            this.handlebarsViewResolver.getHandlebars().infiniteLoops(true);
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"handlebars.prettyPrint"})
    protected static class PrettyPrintConfiguration {
        @Autowired
        private HandlebarsViewResolver handlebarsViewResolver;

        protected PrettyPrintConfiguration() {
        }

        @PostConstruct
        public void setPrettyPrint() {
            this.handlebarsViewResolver.getHandlebars().prettyPrint(true);
        }
    }

    @Configuration
    @ConditionalOnBean(value={TemplateLoader.class})
    protected static class HandlebarsTemplateLoaderConfiguration {
        @Autowired
        private HandlebarsViewResolver handlebarsViewResolver;
        @Autowired
        private TemplateLoader templateLoader;

        protected HandlebarsTemplateLoaderConfiguration() {
        }

        @PostConstruct
        public void setTemplateLoader() {
            this.handlebarsViewResolver.getHandlebars().with(new TemplateLoader[]{this.templateLoader});
        }
    }

    @Configuration
    protected static class HandlebarsCachingStrategyConfiguration {
        @Autowired
        private HandlebarsViewResolver handlebarsViewResolver;
        @Autowired
        private TemplateCache templateCacheInstance;

        protected HandlebarsCachingStrategyConfiguration() {
        }

        @PostConstruct
        public void setCachingStrategy() {
            if (this.handlebarsViewResolver.isCache()) {
                this.handlebarsViewResolver.getHandlebars().with(this.templateCacheInstance);
            }
        }
    }

    @Configuration
    protected static class HandlebarsCacheConfiguration {
        protected HandlebarsCacheConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public TemplateCache templateCache() {
            return new GuavaTemplateCache(CacheBuilder.newBuilder().build());
        }
    }

    @Configuration
    protected static class HandlebarsViewResolverConfiguration {
        @Autowired
        private HandlebarsProperties handlebars;

        protected HandlebarsViewResolverConfiguration() {
        }

        @Bean
        public HandlebarsViewResolver handlebarsViewResolver() {
            HandlebarsViewResolver handlebarsViewResolver = new HandlebarsViewResolver();
            this.handlebars.applyToMvcViewResolver(handlebarsViewResolver);
            return handlebarsViewResolver;
        }
    }
}

